/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Billing details of an order.")
public class OrderBilling {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="phone")
    private String phone = null;
    @SerializedName(value="postCode")
    private String postCode = null;
    @SerializedName(value="paymentMethod")
    private String paymentMethod = null;
    @SerializedName(value="region")
    private String region = null;

    public OrderBilling address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="15 Somewhere Road, Brynmenyn", value="Full billing address.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public OrderBilling city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="Basel", value="Exact city of the address.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public OrderBilling countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="CA", value="Billing country 2-letter ISO code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public OrderBilling phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(example="01559 032133", value="Phone number to contact for further details about the order, Mandatory if \"email\" field is not passed.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public OrderBilling postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @ApiModelProperty(example="4052", value="Postcode for delivery and billing.")
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public OrderBilling paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(example="PayPal", value="How the visitor will pay for the item(s), e.g. paypal, check, etc.")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public OrderBilling region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(example="Northwestern Switzerland", value="Exact region (state/province) for delivery and billing.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBilling orderBilling = (OrderBilling)o;
        return ObjectUtils.equals((Object)this.address, (Object)orderBilling.address) && ObjectUtils.equals((Object)this.city, (Object)orderBilling.city) && ObjectUtils.equals((Object)this.countryCode, (Object)orderBilling.countryCode) && ObjectUtils.equals((Object)this.phone, (Object)orderBilling.phone) && ObjectUtils.equals((Object)this.postCode, (Object)orderBilling.postCode) && ObjectUtils.equals((Object)this.paymentMethod, (Object)orderBilling.paymentMethod) && ObjectUtils.equals((Object)this.region, (Object)orderBilling.region);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.address, this.city, this.countryCode, this.phone, this.postCode, this.paymentMethod, this.region});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderBilling {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

