/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import sibModel.OrderBilling;
import sibModel.OrderProducts;

public class Order {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="createdAt")
    private String createdAt = null;
    @SerializedName(value="updatedAt")
    private String updatedAt = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="products")
    private List<OrderProducts> products = new ArrayList<OrderProducts>();
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="billing")
    private OrderBilling billing = null;
    @SerializedName(value="coupons")
    private List<String> coupons = null;

    public Order id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="14", required=true, value="Unique ID of the order.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Order createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2021-07-29T20:59:23.383Z", required=true, value="Event occurrence UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when order is actually created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Order updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2021-07-30T10:59:23.383Z", required=true, value="Event updated UTC date-time (YYYY-MM-DDTHH:mm:ssZ), when the status of the order is actually changed/updated.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Order status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="completed", required=true, value="State of the order.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Order amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="308.42", required=true, value="Total amount of the order, including all shipping expenses, tax and the price of items.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Order products(List<OrderProducts> products) {
        this.products = products;
        return this;
    }

    public Order addProductsItem(OrderProducts productsItem) {
        this.products.add(productsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<OrderProducts> getProducts() {
        return this.products;
    }

    public void setProducts(List<OrderProducts> products) {
        this.products = products;
    }

    public Order email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="example@sendinblue.com", value="Email of the contact, Mandatory if \"phone\" field is not passed in \"billing\" parameter.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Order billing(OrderBilling billing) {
        this.billing = billing;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderBilling getBilling() {
        return this.billing;
    }

    public void setBilling(OrderBilling billing) {
        this.billing = billing;
    }

    public Order coupons(List<String> coupons) {
        this.coupons = coupons;
        return this;
    }

    public Order addCouponsItem(String couponsItem) {
        if (this.coupons == null) {
            this.coupons = new ArrayList<String>();
        }
        this.coupons.add(couponsItem);
        return this;
    }

    @ApiModelProperty(example="[\"EASTER15OFF\"]", value="Coupons applied to the order. Stored case insensitive.")
    public List<String> getCoupons() {
        return this.coupons;
    }

    public void setCoupons(List<String> coupons) {
        this.coupons = coupons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return ObjectUtils.equals((Object)this.id, (Object)order.id) && ObjectUtils.equals((Object)this.createdAt, (Object)order.createdAt) && ObjectUtils.equals((Object)this.updatedAt, (Object)order.updatedAt) && ObjectUtils.equals((Object)this.status, (Object)order.status) && ObjectUtils.equals((Object)this.amount, (Object)order.amount) && ObjectUtils.equals(this.products, order.products) && ObjectUtils.equals((Object)this.email, (Object)order.email) && ObjectUtils.equals((Object)this.billing, (Object)order.billing) && ObjectUtils.equals(this.coupons, order.coupons);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.createdAt, this.updatedAt, this.status, this.amount, this.products, this.email, this.billing, this.coupons});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Order {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    coupons: ").append(this.toIndentedString(this.coupons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

