/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Note data to be saved")
public class NoteData {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="contactIds")
    private List<Integer> contactIds = null;
    @SerializedName(value="dealIds")
    private List<String> dealIds = null;
    @SerializedName(value="companyIds")
    private List<String> companyIds = null;

    public NoteData text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="In communication with client for resolution of queries.", required=true, value="Text content of a note")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NoteData contactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    public NoteData addContactIdsItem(Integer contactIdsItem) {
        if (this.contactIds == null) {
            this.contactIds = new ArrayList<Integer>();
        }
        this.contactIds.add(contactIdsItem);
        return this;
    }

    @ApiModelProperty(example="[247,1,2]", value="Contact Ids linked to a note")
    public List<Integer> getContactIds() {
        return this.contactIds;
    }

    public void setContactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
    }

    public NoteData dealIds(List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public NoteData addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value="Deal Ids linked to a note")
    public List<String> getDealIds() {
        return this.dealIds;
    }

    public void setDealIds(List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public NoteData companyIds(List<String> companyIds) {
        this.companyIds = companyIds;
        return this;
    }

    public NoteData addCompanyIdsItem(String companyIdsItem) {
        if (this.companyIds == null) {
            this.companyIds = new ArrayList<String>();
        }
        this.companyIds.add(companyIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value="Company Ids linked to a note")
    public List<String> getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(List<String> companyIds) {
        this.companyIds = companyIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteData noteData = (NoteData)o;
        return ObjectUtils.equals((Object)this.text, (Object)noteData.text) && ObjectUtils.equals(this.contactIds, noteData.contactIds) && ObjectUtils.equals(this.dealIds, noteData.dealIds) && ObjectUtils.equals(this.companyIds, noteData.companyIds);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.text, this.contactIds, this.dealIds, this.companyIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteData {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("    companyIds: ").append(this.toIndentedString(this.companyIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

