/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Note Details")
public class Note {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="contactIds")
    private List<Integer> contactIds = null;
    @SerializedName(value="dealIds")
    private List<String> dealIds = null;
    @SerializedName(value="authorId")
    private Object authorId = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;

    public Note id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad09", value="Unique note Id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Note text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="In communication with client for resolution of queries.", required=true, value="Text content of a note")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Note contactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    public Note addContactIdsItem(Integer contactIdsItem) {
        if (this.contactIds == null) {
            this.contactIds = new ArrayList<Integer>();
        }
        this.contactIds.add(contactIdsItem);
        return this;
    }

    @ApiModelProperty(example="[247,1,2]", value="Contact ids linked to a note")
    public List<Integer> getContactIds() {
        return this.contactIds;
    }

    public void setContactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
    }

    public Note dealIds(List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public Note addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value="Deal ids linked to a note")
    public List<String> getDealIds() {
        return this.dealIds;
    }

    public void setDealIds(List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public Note authorId(Object authorId) {
        this.authorId = authorId;
        return this;
    }

    @ApiModelProperty(example="{\"id\":\"61a5ce58y5d4795761045991\",\"email\":\"johndoe@example.com\",\"locale\":\"en_GB\",\"timezone\":\"Asia/Kolkata\",\"name\":{\"fullName\":\"John Doe\"}}", value="Account details of user which created the note")
    public Object getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Object authorId) {
        this.authorId = authorId;
    }

    public Note createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="Note created date/time")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Note updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="Note updated date/time")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return ObjectUtils.equals((Object)this.id, (Object)note.id) && ObjectUtils.equals((Object)this.text, (Object)note.text) && ObjectUtils.equals(this.contactIds, note.contactIds) && ObjectUtils.equals(this.dealIds, note.dealIds) && ObjectUtils.equals((Object)this.authorId, (Object)note.authorId) && ObjectUtils.equals((Object)this.createdAt, (Object)note.createdAt) && ObjectUtils.equals((Object)this.updatedAt, (Object)note.updatedAt);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.text, this.contactIds, this.dealIds, this.authorId, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Note {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

