/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Deal Details")
public class Deal {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="linkedContactsIds")
    private List<Integer> linkedContactsIds = null;
    @SerializedName(value="linkedCompaniesIds")
    private List<String> linkedCompaniesIds = null;

    public Deal id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="629475917295261d9b1f4403", value="Unique deal id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Deal attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"deal_name\":\"testname\",\"deal_owner\":\"6093d2425a9b436e9519d034\",\"amount\":12,\"pipeline\":\"6093d296ad1e9c5cf2140a58\",\"deal_stage\":\"9e577ff7-8e42-4ab3-be26-2b5e01b42518\",\"stage_updated_at\":\"2022-05-30T07:42:05.671Z\",\"created_at\":\"2022-05-30T07:42:05.671Z\",\"number_of_contacts\":1,\"last_updated_date\":\"2022-06-06T08:38:36.761Z\",\"last_activity_date\":\"2022-06-06T08:38:36.000Z\",\"number_of_activities\":0}", value="Deal attributes with values")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public Deal linkedContactsIds(List<Integer> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
        return this;
    }

    public Deal addLinkedContactsIdsItem(Integer linkedContactsIdsItem) {
        if (this.linkedContactsIds == null) {
            this.linkedContactsIds = new ArrayList<Integer>();
        }
        this.linkedContactsIds.add(linkedContactsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[1,2,3]", value="Contact ids for contacts linked to this deal")
    public List<Integer> getLinkedContactsIds() {
        return this.linkedContactsIds;
    }

    public void setLinkedContactsIds(List<Integer> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
    }

    public Deal linkedCompaniesIds(List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
        return this;
    }

    public Deal addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
        if (this.linkedCompaniesIds == null) {
            this.linkedCompaniesIds = new ArrayList<String>();
        }
        this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Companies ids for companies linked to this deal")
    public List<String> getLinkedCompaniesIds() {
        return this.linkedCompaniesIds;
    }

    public void setLinkedCompaniesIds(List<String> linkedCompaniesIds) {
        this.linkedCompaniesIds = linkedCompaniesIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deal deal = (Deal)o;
        return ObjectUtils.equals((Object)this.id, (Object)deal.id) && ObjectUtils.equals((Object)this.attributes, (Object)deal.attributes) && ObjectUtils.equals(this.linkedContactsIds, deal.linkedContactsIds) && ObjectUtils.equals(this.linkedCompaniesIds, deal.linkedCompaniesIds);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.attributes, this.linkedContactsIds, this.linkedCompaniesIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Deal {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    linkedContactsIds: ").append(this.toIndentedString(this.linkedContactsIds)).append("\n");
        sb.append("    linkedCompaniesIds: ").append(this.toIndentedString(this.linkedCompaniesIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

