/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class CreateContact {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="emailBlacklisted")
    private Boolean emailBlacklisted = null;
    @SerializedName(value="smsBlacklisted")
    private Boolean smsBlacklisted = null;
    @SerializedName(value="listIds")
    private List<Long> listIds = null;
    @SerializedName(value="updateEnabled")
    private Boolean updateEnabled = false;
    @SerializedName(value="smtpBlacklistSender")
    private List<String> smtpBlacklistSender = null;

    public CreateContact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="elly@example.com", value="Email address of the user. Mandatory if \"SMS\" field is not passed in \"attributes\" parameter. Mobile Number in \"SMS\" field should be passed with proper country code. For example {\"SMS\":\"+91xxxxxxxxxx\"} or {\"SMS\":\"0091xxxxxxxxxx\"}")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateContact attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"FNAME\":\"Elly\",\"LNAME\":\"Roger\"}", value="Pass the set of attributes and their values. The attribute's parameter should be passed in capital letter while creating a contact. These attributes must be present in your SendinBlue account. For eg. {\"FNAME\":\"Elly\", \"LNAME\":\"Roger\"}")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public CreateContact emailBlacklisted(Boolean emailBlacklisted) {
        this.emailBlacklisted = emailBlacklisted;
        return this;
    }

    @ApiModelProperty(example="false", value="Set this field to blacklist the contact for emails (emailBlacklisted = true)")
    public Boolean isEmailBlacklisted() {
        return this.emailBlacklisted;
    }

    public void setEmailBlacklisted(Boolean emailBlacklisted) {
        this.emailBlacklisted = emailBlacklisted;
    }

    public CreateContact smsBlacklisted(Boolean smsBlacklisted) {
        this.smsBlacklisted = smsBlacklisted;
        return this;
    }

    @ApiModelProperty(example="false", value="Set this field to blacklist the contact for SMS (smsBlacklisted = true)")
    public Boolean isSmsBlacklisted() {
        return this.smsBlacklisted;
    }

    public void setSmsBlacklisted(Boolean smsBlacklisted) {
        this.smsBlacklisted = smsBlacklisted;
    }

    public CreateContact listIds(List<Long> listIds) {
        this.listIds = listIds;
        return this;
    }

    public CreateContact addListIdsItem(Long listIdsItem) {
        if (this.listIds == null) {
            this.listIds = new ArrayList<Long>();
        }
        this.listIds.add(listIdsItem);
        return this;
    }

    @ApiModelProperty(value="Ids of the lists to add the contact to")
    public List<Long> getListIds() {
        return this.listIds;
    }

    public void setListIds(List<Long> listIds) {
        this.listIds = listIds;
    }

    public CreateContact updateEnabled(Boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="Facilitate to update the existing contact in the same request (updateEnabled = true)")
    public Boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public void setUpdateEnabled(Boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
    }

    public CreateContact smtpBlacklistSender(List<String> smtpBlacklistSender) {
        this.smtpBlacklistSender = smtpBlacklistSender;
        return this;
    }

    public CreateContact addSmtpBlacklistSenderItem(String smtpBlacklistSenderItem) {
        if (this.smtpBlacklistSender == null) {
            this.smtpBlacklistSender = new ArrayList<String>();
        }
        this.smtpBlacklistSender.add(smtpBlacklistSenderItem);
        return this;
    }

    @ApiModelProperty(value="transactional email forbidden sender for contact. Use only for email Contact ( only available if updateEnabled = true )")
    public List<String> getSmtpBlacklistSender() {
        return this.smtpBlacklistSender;
    }

    public void setSmtpBlacklistSender(List<String> smtpBlacklistSender) {
        this.smtpBlacklistSender = smtpBlacklistSender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateContact createContact = (CreateContact)o;
        return ObjectUtils.equals((Object)this.email, (Object)createContact.email) && ObjectUtils.equals((Object)this.attributes, (Object)createContact.attributes) && ObjectUtils.equals((Object)this.emailBlacklisted, (Object)createContact.emailBlacklisted) && ObjectUtils.equals((Object)this.smsBlacklisted, (Object)createContact.smsBlacklisted) && ObjectUtils.equals(this.listIds, createContact.listIds) && ObjectUtils.equals((Object)this.updateEnabled, (Object)createContact.updateEnabled) && ObjectUtils.equals(this.smtpBlacklistSender, createContact.smtpBlacklistSender);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.email, this.attributes, this.emailBlacklisted, this.smsBlacklisted, this.listIds, this.updateEnabled, this.smtpBlacklistSender});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateContact {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    emailBlacklisted: ").append(this.toIndentedString(this.emailBlacklisted)).append("\n");
        sb.append("    smsBlacklisted: ").append(this.toIndentedString(this.smsBlacklisted)).append("\n");
        sb.append("    listIds: ").append(this.toIndentedString(this.listIds)).append("\n");
        sb.append("    updateEnabled: ").append(this.toIndentedString(this.updateEnabled)).append("\n");
        sb.append("    smtpBlacklistSender: ").append(this.toIndentedString(this.smtpBlacklistSender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

