/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.AddContactToList;
import sibModel.CreateAttribute;
import sibModel.CreateContact;
import sibModel.CreateDoiContact;
import sibModel.CreateList;
import sibModel.CreateModel;
import sibModel.CreateUpdateContactModel;
import sibModel.CreateUpdateFolder;
import sibModel.CreatedProcessId;
import sibModel.GetAttributes;
import sibModel.GetContactCampaignStats;
import sibModel.GetContacts;
import sibModel.GetExtendedContactDetails;
import sibModel.GetExtendedList;
import sibModel.GetFolder;
import sibModel.GetFolderLists;
import sibModel.GetFolders;
import sibModel.GetLists;
import sibModel.PostContactInfo;
import sibModel.RemoveContactFromList;
import sibModel.RequestContactExport;
import sibModel.RequestContactImport;
import sibModel.UpdateAttribute;
import sibModel.UpdateBatchContacts;
import sibModel.UpdateContact;
import sibModel.UpdateList;

public class ContactsApi {
    private ApiClient apiClient;

    public ContactsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addContactToListCall(Long listId, AddContactToList contactEmails, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddContactToList localVarPostBody = contactEmails;
        String localVarPath = "/contacts/lists/{listId}/contacts/add".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addContactToListValidateBeforeCall(Long listId, AddContactToList contactEmails, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling addContactToList(Async)");
        }
        if (contactEmails == null) {
            throw new ApiException("Missing the required parameter 'contactEmails' when calling addContactToList(Async)");
        }
        Call call = this.addContactToListCall(listId, contactEmails, progressListener, progressRequestListener);
        return call;
    }

    public PostContactInfo addContactToList(Long listId, AddContactToList contactEmails) throws ApiException {
        ApiResponse<PostContactInfo> resp = this.addContactToListWithHttpInfo(listId, contactEmails);
        return resp.getData();
    }

    public ApiResponse<PostContactInfo> addContactToListWithHttpInfo(Long listId, AddContactToList contactEmails) throws ApiException {
        Call call = this.addContactToListValidateBeforeCall(listId, contactEmails, null, null);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addContactToListAsync(Long listId, AddContactToList contactEmails, final ApiCallback<PostContactInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addContactToListValidateBeforeCall(listId, contactEmails, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createAttributeCall(String attributeCategory, String attributeName, CreateAttribute createAttribute, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateAttribute localVarPostBody = createAttribute;
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(attributeCategory.toString())).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(attributeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createAttributeValidateBeforeCall(String attributeCategory, String attributeName, CreateAttribute createAttribute, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attributeCategory == null) {
            throw new ApiException("Missing the required parameter 'attributeCategory' when calling createAttribute(Async)");
        }
        if (attributeName == null) {
            throw new ApiException("Missing the required parameter 'attributeName' when calling createAttribute(Async)");
        }
        if (createAttribute == null) {
            throw new ApiException("Missing the required parameter 'createAttribute' when calling createAttribute(Async)");
        }
        Call call = this.createAttributeCall(attributeCategory, attributeName, createAttribute, progressListener, progressRequestListener);
        return call;
    }

    public void createAttribute(String attributeCategory, String attributeName, CreateAttribute createAttribute) throws ApiException {
        this.createAttributeWithHttpInfo(attributeCategory, attributeName, createAttribute);
    }

    public ApiResponse<Void> createAttributeWithHttpInfo(String attributeCategory, String attributeName, CreateAttribute createAttribute) throws ApiException {
        Call call = this.createAttributeValidateBeforeCall(attributeCategory, attributeName, createAttribute, null, null);
        return this.apiClient.execute(call);
    }

    public Call createAttributeAsync(String attributeCategory, String attributeName, CreateAttribute createAttribute, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createAttributeValidateBeforeCall(attributeCategory, attributeName, createAttribute, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createContactCall(CreateContact createContact, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateContact localVarPostBody = createContact;
        String localVarPath = "/contacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createContactValidateBeforeCall(CreateContact createContact, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createContact == null) {
            throw new ApiException("Missing the required parameter 'createContact' when calling createContact(Async)");
        }
        Call call = this.createContactCall(createContact, progressListener, progressRequestListener);
        return call;
    }

    public CreateUpdateContactModel createContact(CreateContact createContact) throws ApiException {
        ApiResponse<CreateUpdateContactModel> resp = this.createContactWithHttpInfo(createContact);
        return resp.getData();
    }

    public ApiResponse<CreateUpdateContactModel> createContactWithHttpInfo(CreateContact createContact) throws ApiException {
        Call call = this.createContactValidateBeforeCall(createContact, null, null);
        Type localVarReturnType = new TypeToken<CreateUpdateContactModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createContactAsync(CreateContact createContact, final ApiCallback<CreateUpdateContactModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createContactValidateBeforeCall(createContact, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateUpdateContactModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createDoiContactCall(CreateDoiContact createDoiContact, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateDoiContact localVarPostBody = createDoiContact;
        String localVarPath = "/contacts/doubleOptinConfirmation";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createDoiContactValidateBeforeCall(CreateDoiContact createDoiContact, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createDoiContact == null) {
            throw new ApiException("Missing the required parameter 'createDoiContact' when calling createDoiContact(Async)");
        }
        Call call = this.createDoiContactCall(createDoiContact, progressListener, progressRequestListener);
        return call;
    }

    public void createDoiContact(CreateDoiContact createDoiContact) throws ApiException {
        this.createDoiContactWithHttpInfo(createDoiContact);
    }

    public ApiResponse<Void> createDoiContactWithHttpInfo(CreateDoiContact createDoiContact) throws ApiException {
        Call call = this.createDoiContactValidateBeforeCall(createDoiContact, null, null);
        return this.apiClient.execute(call);
    }

    public Call createDoiContactAsync(CreateDoiContact createDoiContact, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createDoiContactValidateBeforeCall(createDoiContact, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createFolderCall(CreateUpdateFolder createFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUpdateFolder localVarPostBody = createFolder;
        String localVarPath = "/contacts/folders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createFolderValidateBeforeCall(CreateUpdateFolder createFolder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createFolder == null) {
            throw new ApiException("Missing the required parameter 'createFolder' when calling createFolder(Async)");
        }
        Call call = this.createFolderCall(createFolder, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createFolder(CreateUpdateFolder createFolder) throws ApiException {
        ApiResponse<CreateModel> resp = this.createFolderWithHttpInfo(createFolder);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createFolderWithHttpInfo(CreateUpdateFolder createFolder) throws ApiException {
        Call call = this.createFolderValidateBeforeCall(createFolder, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createFolderAsync(CreateUpdateFolder createFolder, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createFolderValidateBeforeCall(createFolder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createListCall(CreateList createList, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateList localVarPostBody = createList;
        String localVarPath = "/contacts/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createListValidateBeforeCall(CreateList createList, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createList == null) {
            throw new ApiException("Missing the required parameter 'createList' when calling createList(Async)");
        }
        Call call = this.createListCall(createList, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createList(CreateList createList) throws ApiException {
        ApiResponse<CreateModel> resp = this.createListWithHttpInfo(createList);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createListWithHttpInfo(CreateList createList) throws ApiException {
        Call call = this.createListValidateBeforeCall(createList, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createListAsync(CreateList createList, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createListValidateBeforeCall(createList, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAttributeCall(String attributeCategory, String attributeName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(attributeCategory.toString())).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(attributeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAttributeValidateBeforeCall(String attributeCategory, String attributeName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attributeCategory == null) {
            throw new ApiException("Missing the required parameter 'attributeCategory' when calling deleteAttribute(Async)");
        }
        if (attributeName == null) {
            throw new ApiException("Missing the required parameter 'attributeName' when calling deleteAttribute(Async)");
        }
        Call call = this.deleteAttributeCall(attributeCategory, attributeName, progressListener, progressRequestListener);
        return call;
    }

    public void deleteAttribute(String attributeCategory, String attributeName) throws ApiException {
        this.deleteAttributeWithHttpInfo(attributeCategory, attributeName);
    }

    public ApiResponse<Void> deleteAttributeWithHttpInfo(String attributeCategory, String attributeName) throws ApiException {
        Call call = this.deleteAttributeValidateBeforeCall(attributeCategory, attributeName, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteAttributeAsync(String attributeCategory, String attributeName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAttributeValidateBeforeCall(attributeCategory, attributeName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteContactCall(String identifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteContactValidateBeforeCall(String identifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling deleteContact(Async)");
        }
        Call call = this.deleteContactCall(identifier, progressListener, progressRequestListener);
        return call;
    }

    public void deleteContact(String identifier) throws ApiException {
        this.deleteContactWithHttpInfo(identifier);
    }

    public ApiResponse<Void> deleteContactWithHttpInfo(String identifier) throws ApiException {
        Call call = this.deleteContactValidateBeforeCall(identifier, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteContactAsync(String identifier, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteContactValidateBeforeCall(identifier, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteFolderCall(Long folderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFolderValidateBeforeCall(Long folderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderId == null) {
            throw new ApiException("Missing the required parameter 'folderId' when calling deleteFolder(Async)");
        }
        Call call = this.deleteFolderCall(folderId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFolder(Long folderId) throws ApiException {
        this.deleteFolderWithHttpInfo(folderId);
    }

    public ApiResponse<Void> deleteFolderWithHttpInfo(Long folderId) throws ApiException {
        Call call = this.deleteFolderValidateBeforeCall(folderId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFolderAsync(Long folderId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFolderValidateBeforeCall(folderId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteListCall(Long listId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteListValidateBeforeCall(Long listId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling deleteList(Async)");
        }
        Call call = this.deleteListCall(listId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteList(Long listId) throws ApiException {
        this.deleteListWithHttpInfo(listId);
    }

    public ApiResponse<Void> deleteListWithHttpInfo(Long listId) throws ApiException {
        Call call = this.deleteListValidateBeforeCall(listId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteListAsync(Long listId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteListValidateBeforeCall(listId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getAttributesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/attributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAttributesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAttributesCall(progressListener, progressRequestListener);
        return call;
    }

    public GetAttributes getAttributes() throws ApiException {
        ApiResponse<GetAttributes> resp = this.getAttributesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<GetAttributes> getAttributesWithHttpInfo() throws ApiException {
        Call call = this.getAttributesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetAttributes>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAttributesAsync(final ApiCallback<GetAttributes> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAttributesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAttributes>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContactInfoCall(String identifier, Object startDate, Object endDate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContactInfoValidateBeforeCall(String identifier, Object startDate, Object endDate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling getContactInfo(Async)");
        }
        Call call = this.getContactInfoCall(identifier, startDate, endDate, progressListener, progressRequestListener);
        return call;
    }

    public GetExtendedContactDetails getContactInfo(String identifier, Object startDate, Object endDate) throws ApiException {
        ApiResponse<GetExtendedContactDetails> resp = this.getContactInfoWithHttpInfo(identifier, startDate, endDate);
        return resp.getData();
    }

    public ApiResponse<GetExtendedContactDetails> getContactInfoWithHttpInfo(String identifier, Object startDate, Object endDate) throws ApiException {
        Call call = this.getContactInfoValidateBeforeCall(identifier, startDate, endDate, null, null);
        Type localVarReturnType = new TypeToken<GetExtendedContactDetails>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContactInfoAsync(String identifier, Object startDate, Object endDate, final ApiCallback<GetExtendedContactDetails> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContactInfoValidateBeforeCall(identifier, startDate, endDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetExtendedContactDetails>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContactStatsCall(String identifier, String startDate, String endDate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/{identifier}/campaignStats".replaceAll("\\{identifier\\}", this.apiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContactStatsValidateBeforeCall(String identifier, String startDate, String endDate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling getContactStats(Async)");
        }
        Call call = this.getContactStatsCall(identifier, startDate, endDate, progressListener, progressRequestListener);
        return call;
    }

    public GetContactCampaignStats getContactStats(String identifier, String startDate, String endDate) throws ApiException {
        ApiResponse<GetContactCampaignStats> resp = this.getContactStatsWithHttpInfo(identifier, startDate, endDate);
        return resp.getData();
    }

    public ApiResponse<GetContactCampaignStats> getContactStatsWithHttpInfo(String identifier, String startDate, String endDate) throws ApiException {
        Call call = this.getContactStatsValidateBeforeCall(identifier, startDate, endDate, null, null);
        Type localVarReturnType = new TypeToken<GetContactCampaignStats>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContactStatsAsync(String identifier, String startDate, String endDate, final ApiCallback<GetContactCampaignStats> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContactStatsValidateBeforeCall(identifier, startDate, endDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetContactCampaignStats>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContactsCall(Long limit, Long offset, String modifiedSince, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (modifiedSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContactsValidateBeforeCall(Long limit, Long offset, String modifiedSince, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getContactsCall(limit, offset, modifiedSince, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetContacts getContacts(Long limit, Long offset, String modifiedSince, String sort) throws ApiException {
        ApiResponse<GetContacts> resp = this.getContactsWithHttpInfo(limit, offset, modifiedSince, sort);
        return resp.getData();
    }

    public ApiResponse<GetContacts> getContactsWithHttpInfo(Long limit, Long offset, String modifiedSince, String sort) throws ApiException {
        Call call = this.getContactsValidateBeforeCall(limit, offset, modifiedSince, sort, null, null);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContactsAsync(Long limit, Long offset, String modifiedSince, String sort, final ApiCallback<GetContacts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContactsValidateBeforeCall(limit, offset, modifiedSince, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContactsFromListCall(Long listId, String modifiedSince, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}/contacts".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (modifiedSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContactsFromListValidateBeforeCall(Long listId, String modifiedSince, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling getContactsFromList(Async)");
        }
        Call call = this.getContactsFromListCall(listId, modifiedSince, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetContacts getContactsFromList(Long listId, String modifiedSince, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetContacts> resp = this.getContactsFromListWithHttpInfo(listId, modifiedSince, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetContacts> getContactsFromListWithHttpInfo(Long listId, String modifiedSince, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getContactsFromListValidateBeforeCall(listId, modifiedSince, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContactsFromListAsync(Long listId, String modifiedSince, Long limit, Long offset, String sort, final ApiCallback<GetContacts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContactsFromListValidateBeforeCall(listId, modifiedSince, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFolderCall(Long folderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFolderValidateBeforeCall(Long folderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderId == null) {
            throw new ApiException("Missing the required parameter 'folderId' when calling getFolder(Async)");
        }
        Call call = this.getFolderCall(folderId, progressListener, progressRequestListener);
        return call;
    }

    public GetFolder getFolder(Long folderId) throws ApiException {
        ApiResponse<GetFolder> resp = this.getFolderWithHttpInfo(folderId);
        return resp.getData();
    }

    public ApiResponse<GetFolder> getFolderWithHttpInfo(Long folderId) throws ApiException {
        Call call = this.getFolderValidateBeforeCall(folderId, null, null);
        Type localVarReturnType = new TypeToken<GetFolder>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFolderAsync(Long folderId, final ApiCallback<GetFolder> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFolderValidateBeforeCall(folderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetFolder>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFolderListsCall(Long folderId, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders/{folderId}/lists".replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFolderListsValidateBeforeCall(Long folderId, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderId == null) {
            throw new ApiException("Missing the required parameter 'folderId' when calling getFolderLists(Async)");
        }
        Call call = this.getFolderListsCall(folderId, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetFolderLists getFolderLists(Long folderId, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetFolderLists> resp = this.getFolderListsWithHttpInfo(folderId, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetFolderLists> getFolderListsWithHttpInfo(Long folderId, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getFolderListsValidateBeforeCall(folderId, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetFolderLists>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFolderListsAsync(Long folderId, Long limit, Long offset, String sort, final ApiCallback<GetFolderLists> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFolderListsValidateBeforeCall(folderId, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetFolderLists>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFoldersCall(Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFoldersValidateBeforeCall(Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (limit == null) {
            throw new ApiException("Missing the required parameter 'limit' when calling getFolders(Async)");
        }
        if (offset == null) {
            throw new ApiException("Missing the required parameter 'offset' when calling getFolders(Async)");
        }
        Call call = this.getFoldersCall(limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetFolders getFolders(Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetFolders> resp = this.getFoldersWithHttpInfo(limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetFolders> getFoldersWithHttpInfo(Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getFoldersValidateBeforeCall(limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetFolders>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFoldersAsync(Long limit, Long offset, String sort, final ApiCallback<GetFolders> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFoldersValidateBeforeCall(limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetFolders>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListCall(Long listId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListValidateBeforeCall(Long listId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling getList(Async)");
        }
        Call call = this.getListCall(listId, progressListener, progressRequestListener);
        return call;
    }

    public GetExtendedList getList(Long listId) throws ApiException {
        ApiResponse<GetExtendedList> resp = this.getListWithHttpInfo(listId);
        return resp.getData();
    }

    public ApiResponse<GetExtendedList> getListWithHttpInfo(Long listId) throws ApiException {
        Call call = this.getListValidateBeforeCall(listId, null, null);
        Type localVarReturnType = new TypeToken<GetExtendedList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListAsync(Long listId, final ApiCallback<GetExtendedList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListValidateBeforeCall(listId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetExtendedList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListsCall(Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListsValidateBeforeCall(Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getListsCall(limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetLists getLists(Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetLists> resp = this.getListsWithHttpInfo(limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetLists> getListsWithHttpInfo(Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getListsValidateBeforeCall(limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetLists>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListsAsync(Long limit, Long offset, String sort, final ApiCallback<GetLists> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListsValidateBeforeCall(limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetLists>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importContactsCall(RequestContactImport requestContactImport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestContactImport localVarPostBody = requestContactImport;
        String localVarPath = "/contacts/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importContactsValidateBeforeCall(RequestContactImport requestContactImport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestContactImport == null) {
            throw new ApiException("Missing the required parameter 'requestContactImport' when calling importContacts(Async)");
        }
        Call call = this.importContactsCall(requestContactImport, progressListener, progressRequestListener);
        return call;
    }

    public CreatedProcessId importContacts(RequestContactImport requestContactImport) throws ApiException {
        ApiResponse<CreatedProcessId> resp = this.importContactsWithHttpInfo(requestContactImport);
        return resp.getData();
    }

    public ApiResponse<CreatedProcessId> importContactsWithHttpInfo(RequestContactImport requestContactImport) throws ApiException {
        Call call = this.importContactsValidateBeforeCall(requestContactImport, null, null);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importContactsAsync(RequestContactImport requestContactImport, final ApiCallback<CreatedProcessId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importContactsValidateBeforeCall(requestContactImport, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeContactFromListCall(Long listId, RemoveContactFromList contactEmails, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemoveContactFromList localVarPostBody = contactEmails;
        String localVarPath = "/contacts/lists/{listId}/contacts/remove".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeContactFromListValidateBeforeCall(Long listId, RemoveContactFromList contactEmails, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling removeContactFromList(Async)");
        }
        if (contactEmails == null) {
            throw new ApiException("Missing the required parameter 'contactEmails' when calling removeContactFromList(Async)");
        }
        Call call = this.removeContactFromListCall(listId, contactEmails, progressListener, progressRequestListener);
        return call;
    }

    public PostContactInfo removeContactFromList(Long listId, RemoveContactFromList contactEmails) throws ApiException {
        ApiResponse<PostContactInfo> resp = this.removeContactFromListWithHttpInfo(listId, contactEmails);
        return resp.getData();
    }

    public ApiResponse<PostContactInfo> removeContactFromListWithHttpInfo(Long listId, RemoveContactFromList contactEmails) throws ApiException {
        Call call = this.removeContactFromListValidateBeforeCall(listId, contactEmails, null, null);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeContactFromListAsync(Long listId, RemoveContactFromList contactEmails, final ApiCallback<PostContactInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeContactFromListValidateBeforeCall(listId, contactEmails, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call requestContactExportCall(RequestContactExport requestContactExport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RequestContactExport localVarPostBody = requestContactExport;
        String localVarPath = "/contacts/export";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call requestContactExportValidateBeforeCall(RequestContactExport requestContactExport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestContactExport == null) {
            throw new ApiException("Missing the required parameter 'requestContactExport' when calling requestContactExport(Async)");
        }
        Call call = this.requestContactExportCall(requestContactExport, progressListener, progressRequestListener);
        return call;
    }

    public CreatedProcessId requestContactExport(RequestContactExport requestContactExport) throws ApiException {
        ApiResponse<CreatedProcessId> resp = this.requestContactExportWithHttpInfo(requestContactExport);
        return resp.getData();
    }

    public ApiResponse<CreatedProcessId> requestContactExportWithHttpInfo(RequestContactExport requestContactExport) throws ApiException {
        Call call = this.requestContactExportValidateBeforeCall(requestContactExport, null, null);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call requestContactExportAsync(RequestContactExport requestContactExport, final ApiCallback<CreatedProcessId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.requestContactExportValidateBeforeCall(requestContactExport, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatedProcessId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAttributeCall(String attributeCategory, String attributeName, UpdateAttribute updateAttribute, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateAttribute localVarPostBody = updateAttribute;
        String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}".replaceAll("\\{attributeCategory\\}", this.apiClient.escapeString(attributeCategory.toString())).replaceAll("\\{attributeName\\}", this.apiClient.escapeString(attributeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAttributeValidateBeforeCall(String attributeCategory, String attributeName, UpdateAttribute updateAttribute, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attributeCategory == null) {
            throw new ApiException("Missing the required parameter 'attributeCategory' when calling updateAttribute(Async)");
        }
        if (attributeName == null) {
            throw new ApiException("Missing the required parameter 'attributeName' when calling updateAttribute(Async)");
        }
        if (updateAttribute == null) {
            throw new ApiException("Missing the required parameter 'updateAttribute' when calling updateAttribute(Async)");
        }
        Call call = this.updateAttributeCall(attributeCategory, attributeName, updateAttribute, progressListener, progressRequestListener);
        return call;
    }

    public void updateAttribute(String attributeCategory, String attributeName, UpdateAttribute updateAttribute) throws ApiException {
        this.updateAttributeWithHttpInfo(attributeCategory, attributeName, updateAttribute);
    }

    public ApiResponse<Void> updateAttributeWithHttpInfo(String attributeCategory, String attributeName, UpdateAttribute updateAttribute) throws ApiException {
        Call call = this.updateAttributeValidateBeforeCall(attributeCategory, attributeName, updateAttribute, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateAttributeAsync(String attributeCategory, String attributeName, UpdateAttribute updateAttribute, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAttributeValidateBeforeCall(attributeCategory, attributeName, updateAttribute, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateBatchContactsCall(UpdateBatchContacts updateBatchContacts, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateBatchContacts localVarPostBody = updateBatchContacts;
        String localVarPath = "/contacts/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateBatchContactsValidateBeforeCall(UpdateBatchContacts updateBatchContacts, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (updateBatchContacts == null) {
            throw new ApiException("Missing the required parameter 'updateBatchContacts' when calling updateBatchContacts(Async)");
        }
        Call call = this.updateBatchContactsCall(updateBatchContacts, progressListener, progressRequestListener);
        return call;
    }

    public void updateBatchContacts(UpdateBatchContacts updateBatchContacts) throws ApiException {
        this.updateBatchContactsWithHttpInfo(updateBatchContacts);
    }

    public ApiResponse<Void> updateBatchContactsWithHttpInfo(UpdateBatchContacts updateBatchContacts) throws ApiException {
        Call call = this.updateBatchContactsValidateBeforeCall(updateBatchContacts, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateBatchContactsAsync(UpdateBatchContacts updateBatchContacts, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateBatchContactsValidateBeforeCall(updateBatchContacts, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateContactCall(String identifier, UpdateContact updateContact, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateContact localVarPostBody = updateContact;
        String localVarPath = "/contacts/{identifier}".replaceAll("\\{identifier\\}", this.apiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateContactValidateBeforeCall(String identifier, UpdateContact updateContact, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling updateContact(Async)");
        }
        if (updateContact == null) {
            throw new ApiException("Missing the required parameter 'updateContact' when calling updateContact(Async)");
        }
        Call call = this.updateContactCall(identifier, updateContact, progressListener, progressRequestListener);
        return call;
    }

    public void updateContact(String identifier, UpdateContact updateContact) throws ApiException {
        this.updateContactWithHttpInfo(identifier, updateContact);
    }

    public ApiResponse<Void> updateContactWithHttpInfo(String identifier, UpdateContact updateContact) throws ApiException {
        Call call = this.updateContactValidateBeforeCall(identifier, updateContact, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateContactAsync(String identifier, UpdateContact updateContact, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateContactValidateBeforeCall(identifier, updateContact, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateFolderCall(Long folderId, CreateUpdateFolder updateFolder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUpdateFolder localVarPostBody = updateFolder;
        String localVarPath = "/contacts/folders/{folderId}".replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateFolderValidateBeforeCall(Long folderId, CreateUpdateFolder updateFolder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderId == null) {
            throw new ApiException("Missing the required parameter 'folderId' when calling updateFolder(Async)");
        }
        if (updateFolder == null) {
            throw new ApiException("Missing the required parameter 'updateFolder' when calling updateFolder(Async)");
        }
        Call call = this.updateFolderCall(folderId, updateFolder, progressListener, progressRequestListener);
        return call;
    }

    public void updateFolder(Long folderId, CreateUpdateFolder updateFolder) throws ApiException {
        this.updateFolderWithHttpInfo(folderId, updateFolder);
    }

    public ApiResponse<Void> updateFolderWithHttpInfo(Long folderId, CreateUpdateFolder updateFolder) throws ApiException {
        Call call = this.updateFolderValidateBeforeCall(folderId, updateFolder, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateFolderAsync(Long folderId, CreateUpdateFolder updateFolder, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateFolderValidateBeforeCall(folderId, updateFolder, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateListCall(Long listId, UpdateList updateList, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateList localVarPostBody = updateList;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateListValidateBeforeCall(Long listId, UpdateList updateList, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling updateList(Async)");
        }
        if (updateList == null) {
            throw new ApiException("Missing the required parameter 'updateList' when calling updateList(Async)");
        }
        Call call = this.updateListCall(listId, updateList, progressListener, progressRequestListener);
        return call;
    }

    public void updateList(Long listId, UpdateList updateList) throws ApiException {
        this.updateListWithHttpInfo(listId, updateList);
    }

    public ApiResponse<Void> updateListWithHttpInfo(Long listId, UpdateList updateList) throws ApiException {
        Call call = this.updateListValidateBeforeCall(listId, updateList, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateListAsync(Long listId, UpdateList updateList, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateListValidateBeforeCall(listId, updateList, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

