/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sibModel.CreateSenderIps;

/**
 * UpdateSender
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-03-12T11:46:32.800+05:30")
public class UpdateSender {
  @SerializedName("name")
  private String name = null;

  @SerializedName("email")
  private String email = null;

  @SerializedName("ips")
  private List<CreateSenderIps> ips = null;

  public UpdateSender name(String name) {
    this.name = name;
    return this;
  }

   /**
   * From Name to update the sender
   * @return name
  **/
  @ApiModelProperty(example = "Newsletter", value = "From Name to update the sender")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public UpdateSender email(String email) {
    this.email = email;
    return this;
  }

   /**
   * From Email to update the sender
   * @return email
  **/
  @ApiModelProperty(example = "newsletter@mycompany.com", value = "From Email to update the sender")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public UpdateSender ips(List<CreateSenderIps> ips) {
    this.ips = ips;
    return this;
  }

  public UpdateSender addIpsItem(CreateSenderIps ipsItem) {
    if (this.ips == null) {
      this.ips = new ArrayList<CreateSenderIps>();
    }
    this.ips.add(ipsItem);
    return this;
  }

   /**
   * Only in case of dedicated IP, IPs to associate to the sender. If passed, will replace all the existing IPs.
   * @return ips
  **/
  @ApiModelProperty(value = "Only in case of dedicated IP, IPs to associate to the sender. If passed, will replace all the existing IPs.")
  public List<CreateSenderIps> getIps() {
    return ips;
  }

  public void setIps(List<CreateSenderIps> ips) {
    this.ips = ips;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    UpdateSender updateSender = (UpdateSender) o;
    return ObjectUtils.equals(this.name, updateSender.name) &&
    ObjectUtils.equals(this.email, updateSender.email) &&
    ObjectUtils.equals(this.ips, updateSender.ips);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(name, email, ips);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateSender {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    ips: ").append(toIndentedString(ips)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

