/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;
import sibModel.GetTransacBlockedContactsReason;

/**
 * GetTransacBlockedContactsContacts
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-03-12T11:46:32.800+05:30")
public class GetTransacBlockedContactsContacts {
  @SerializedName("email")
  private String email = null;

  @SerializedName("senderEmail")
  private String senderEmail = null;

  @SerializedName("reason")
  private GetTransacBlockedContactsReason reason = null;

  @SerializedName("blockedAt")
  private String blockedAt = null;

  public GetTransacBlockedContactsContacts email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Email address of the blocked or unsubscribed contact
   * @return email
  **/
  @ApiModelProperty(example = "john.smith@example.com", required = true, value = "Email address of the blocked or unsubscribed contact")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public GetTransacBlockedContactsContacts senderEmail(String senderEmail) {
    this.senderEmail = senderEmail;
    return this;
  }

   /**
   * Sender email address of the blocked or unsubscribed contact
   * @return senderEmail
  **/
  @ApiModelProperty(example = "john.smith@example.com", required = true, value = "Sender email address of the blocked or unsubscribed contact")
  public String getSenderEmail() {
    return senderEmail;
  }

  public void setSenderEmail(String senderEmail) {
    this.senderEmail = senderEmail;
  }

  public GetTransacBlockedContactsContacts reason(GetTransacBlockedContactsReason reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Get reason
   * @return reason
  **/
  @ApiModelProperty(required = true, value = "")
  public GetTransacBlockedContactsReason getReason() {
    return reason;
  }

  public void setReason(GetTransacBlockedContactsReason reason) {
    this.reason = reason;
  }

  public GetTransacBlockedContactsContacts blockedAt(String blockedAt) {
    this.blockedAt = blockedAt;
    return this;
  }

   /**
   * Date when the contact was blocked or unsubscribed on
   * @return blockedAt
  **/
  @ApiModelProperty(example = "2017-05-01T12:30:00Z", required = true, value = "Date when the contact was blocked or unsubscribed on")
  public String getBlockedAt() {
    return blockedAt;
  }

  public void setBlockedAt(String blockedAt) {
    this.blockedAt = blockedAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    GetTransacBlockedContactsContacts getTransacBlockedContactsContacts = (GetTransacBlockedContactsContacts) o;
    return ObjectUtils.equals(this.email, getTransacBlockedContactsContacts.email) &&
    ObjectUtils.equals(this.senderEmail, getTransacBlockedContactsContacts.senderEmail) &&
    ObjectUtils.equals(this.reason, getTransacBlockedContactsContacts.reason) &&
    ObjectUtils.equals(this.blockedAt, getTransacBlockedContactsContacts.blockedAt);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(email, senderEmail, reason, blockedAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTransacBlockedContactsContacts {\n");
    
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    senderEmail: ").append(toIndentedString(senderEmail)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    blockedAt: ").append(toIndentedString(blockedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

