/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;

/**
 * GetEmailEventReportEvents
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-03-12T11:46:32.800+05:30")
public class GetEmailEventReportEvents {
  @SerializedName("email")
  private String email = null;

  @SerializedName("date")
  private String date = null;

  @SerializedName("subject")
  private String subject = null;

  @SerializedName("messageId")
  private String messageId = null;

  /**
   * Event which occurred
   */
  @JsonAdapter(EventEnum.Adapter.class)
  public enum EventEnum {
    BOUNCES("bounces"),
    
    HARDBOUNCES("hardBounces"),
    
    SOFTBOUNCES("softBounces"),
    
    DELIVERED("delivered"),
    
    SPAM("spam"),
    
    REQUESTS("requests"),
    
    OPENED("opened"),
    
    CLICKS("clicks"),
    
    INVALID("invalid"),
    
    DEFERRED("deferred"),
    
    BLOCKED("blocked"),
    
    UNSUBSCRIBED("unsubscribed"),
    
    ERROR("error");

    private String value;

    EventEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EventEnum fromValue(String text) {
      for (EventEnum b : EventEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EventEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EventEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EventEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return EventEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("event")
  private EventEnum event = null;

  @SerializedName("reason")
  private String reason = null;

  @SerializedName("tag")
  private String tag = null;

  @SerializedName("ip")
  private String ip = null;

  @SerializedName("link")
  private String link = null;

  @SerializedName("from")
  private String from = null;

  @SerializedName("templateId")
  private Long templateId = null;

  public GetEmailEventReportEvents email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Email address which generates the event
   * @return email
  **/
  @ApiModelProperty(example = "john.smith@example.com", required = true, value = "Email address which generates the event")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public GetEmailEventReportEvents date(String date) {
    this.date = date;
    return this;
  }

   /**
   * UTC date-time on which the event has been generated
   * @return date
  **/
  @ApiModelProperty(example = "2017-03-12T12:30:00Z", required = true, value = "UTC date-time on which the event has been generated")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public GetEmailEventReportEvents subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Subject of the event
   * @return subject
  **/
  @ApiModelProperty(example = "Sib client test", value = "Subject of the event")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public GetEmailEventReportEvents messageId(String messageId) {
    this.messageId = messageId;
    return this;
  }

   /**
   * Message ID which generated the event
   * @return messageId
  **/
  @ApiModelProperty(example = "<201798300811.5787683@relay.domain.com>", required = true, value = "Message ID which generated the event")
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public GetEmailEventReportEvents event(EventEnum event) {
    this.event = event;
    return this;
  }

   /**
   * Event which occurred
   * @return event
  **/
  @ApiModelProperty(example = "delivered", required = true, value = "Event which occurred")
  public EventEnum getEvent() {
    return event;
  }

  public void setEvent(EventEnum event) {
    this.event = event;
  }

  public GetEmailEventReportEvents reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Reason of bounce (only available if the event is hardbounce or softbounce)
   * @return reason
  **/
  @ApiModelProperty(example = "Error connection timeout", value = "Reason of bounce (only available if the event is hardbounce or softbounce)")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public GetEmailEventReportEvents tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Tag of the email which generated the event
   * @return tag
  **/
  @ApiModelProperty(example = "OrderConfirmation", value = "Tag of the email which generated the event")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public GetEmailEventReportEvents ip(String ip) {
    this.ip = ip;
    return this;
  }

   /**
   * IP from which the user has opened the email or clicked on the link (only available if the event is opened or clicks)
   * @return ip
  **/
  @ApiModelProperty(example = "165.87.3.15", value = "IP from which the user has opened the email or clicked on the link (only available if the event is opened or clicks)")
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }

  public GetEmailEventReportEvents link(String link) {
    this.link = link;
    return this;
  }

   /**
   * The link which is sent to the user (only available if the event is requests or opened or clicks)
   * @return link
  **/
  @ApiModelProperty(example = "https://www.someexamplelink.com", value = "The link which is sent to the user (only available if the event is requests or opened or clicks)")
  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  public GetEmailEventReportEvents from(String from) {
    this.from = from;
    return this;
  }

   /**
   * Sender email from which the emails are sent
   * @return from
  **/
  @ApiModelProperty(example = "john@example.com", value = "Sender email from which the emails are sent")
  public String getFrom() {
    return from;
  }

  public void setFrom(String from) {
    this.from = from;
  }

  public GetEmailEventReportEvents templateId(Long templateId) {
    this.templateId = templateId;
    return this;
  }

   /**
   * ID of the template (only available if the email is template based)
   * @return templateId
  **/
  @ApiModelProperty(example = "4", value = "ID of the template (only available if the email is template based)")
  public Long getTemplateId() {
    return templateId;
  }

  public void setTemplateId(Long templateId) {
    this.templateId = templateId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    GetEmailEventReportEvents getEmailEventReportEvents = (GetEmailEventReportEvents) o;
    return ObjectUtils.equals(this.email, getEmailEventReportEvents.email) &&
    ObjectUtils.equals(this.date, getEmailEventReportEvents.date) &&
    ObjectUtils.equals(this.subject, getEmailEventReportEvents.subject) &&
    ObjectUtils.equals(this.messageId, getEmailEventReportEvents.messageId) &&
    ObjectUtils.equals(this.event, getEmailEventReportEvents.event) &&
    ObjectUtils.equals(this.reason, getEmailEventReportEvents.reason) &&
    ObjectUtils.equals(this.tag, getEmailEventReportEvents.tag) &&
    ObjectUtils.equals(this.ip, getEmailEventReportEvents.ip) &&
    ObjectUtils.equals(this.link, getEmailEventReportEvents.link) &&
    ObjectUtils.equals(this.from, getEmailEventReportEvents.from) &&
    ObjectUtils.equals(this.templateId, getEmailEventReportEvents.templateId);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(email, date, subject, messageId, event, reason, tag, ip, link, from, templateId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetEmailEventReportEvents {\n");
    
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

