/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * ErrorModel
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-03-12T11:46:32.800+05:30")
public class ErrorModel {
  /**
   * Error code displayed in case of a failure
   */
  @JsonAdapter(CodeEnum.Adapter.class)
  public enum CodeEnum {
    INVALID_PARAMETER("invalid_parameter"),
    
    MISSING_PARAMETER("missing_parameter"),
    
    OUT_OF_RANGE("out_of_range"),
    
    CAMPAIGN_PROCESSING("campaign_processing"),
    
    CAMPAIGN_SENT("campaign_sent"),
    
    DOCUMENT_NOT_FOUND("document_not_found"),
    
    RESELLER_PERMISSION_DENIED("reseller_permission_denied"),
    
    NOT_ENOUGH_CREDITS("not_enough_credits"),
    
    PERMISSION_DENIED("permission_denied"),
    
    DUPLICATE_PARAMETER("duplicate_parameter"),
    
    DUPLICATE_REQUEST("duplicate_request"),
    
    METHOD_NOT_ALLOWED("method_not_allowed"),
    
    UNAUTHORIZED("unauthorized"),
    
    ACCOUNT_UNDER_VALIDATION("account_under_validation"),
    
    NOT_ACCEPTABLE("not_acceptable");

    private String value;

    CodeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CodeEnum fromValue(String text) {
      for (CodeEnum b : CodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<CodeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CodeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CodeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return CodeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("code")
  private CodeEnum code = null;

  @SerializedName("message")
  private String message = null;

  public ErrorModel code(CodeEnum code) {
    this.code = code;
    return this;
  }

   /**
   * Error code displayed in case of a failure
   * @return code
  **/
  @ApiModelProperty(example = "method_not_allowed", required = true, value = "Error code displayed in case of a failure")
  public CodeEnum getCode() {
    return code;
  }

  public void setCode(CodeEnum code) {
    this.code = code;
  }

  public ErrorModel message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Readable message associated to the failure
   * @return message
  **/
  @ApiModelProperty(example = "POST Method is not allowed on this path", required = true, value = "Readable message associated to the failure")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    ErrorModel errorModel = (ErrorModel) o;
    return ObjectUtils.equals(this.code, errorModel.code) &&
    ObjectUtils.equals(this.message, errorModel.message);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(code, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErrorModel {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

