/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import org.apache.commons.lang3.ObjectUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateSenderModel
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-03-12T11:46:32.800+05:30")
public class CreateSenderModel {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("spfError")
  private Boolean spfError = null;

  @SerializedName("dkimError")
  private Boolean dkimError = null;

  public CreateSenderModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * ID of the Sender created
   * @return id
  **/
  @ApiModelProperty(example = "5", required = true, value = "ID of the Sender created")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public CreateSenderModel spfError(Boolean spfError) {
    this.spfError = spfError;
    return this;
  }

   /**
   * Status of SPF configuration for the sender (true &#x3D; SPF not well configured, false &#x3D; SPF well configured)
   * @return spfError
  **/
  @ApiModelProperty(example = "true", value = "Status of SPF configuration for the sender (true = SPF not well configured, false = SPF well configured)")
  public Boolean isSpfError() {
    return spfError;
  }

  public void setSpfError(Boolean spfError) {
    this.spfError = spfError;
  }

  public CreateSenderModel dkimError(Boolean dkimError) {
    this.dkimError = dkimError;
    return this;
  }

   /**
   * Status of DKIM configuration for the sender (true &#x3D; DKIM not well configured, false &#x3D; DKIM well configured)
   * @return dkimError
  **/
  @ApiModelProperty(example = "false", value = "Status of DKIM configuration for the sender (true = DKIM not well configured, false = DKIM well configured)")
  public Boolean isDkimError() {
    return dkimError;
  }

  public void setDkimError(Boolean dkimError) {
    this.dkimError = dkimError;
  }


  @Override
  public boolean equals(java.lang.Object o) {
  if (this == o) {
    return true;
  }
  if (o == null || getClass() != o.getClass()) {
    return false;
  }
    CreateSenderModel createSenderModel = (CreateSenderModel) o;
    return ObjectUtils.equals(this.id, createSenderModel.id) &&
    ObjectUtils.equals(this.spfError, createSenderModel.spfError) &&
    ObjectUtils.equals(this.dkimError, createSenderModel.dkimError);
  }

  @Override
  public int hashCode() {
    return ObjectUtils.hashCodeMulti(id, spfError, dkimError);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateSenderModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    spfError: ").append(toIndentedString(spfError)).append("\n");
    sb.append("    dkimError: ").append(toIndentedString(dkimError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

