/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibApi;

import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import sibModel.BlockDomain;
import sibModel.CreateModel;
import sibModel.CreateSmtpEmail;
import sibModel.CreateSmtpTemplate;
import sibModel.DeleteHardbounces;
import sibModel.ErrorModel;
import sibModel.GetAggregatedReport;
import sibModel.GetBlockedDomains;
import sibModel.GetEmailEventReport;
import sibModel.GetReports;
import sibModel.GetSmtpTemplateOverview;
import sibModel.GetSmtpTemplates;
import sibModel.GetTransacBlockedContacts;
import sibModel.GetTransacEmailContent;
import sibModel.GetTransacEmailsList;
import org.threeten.bp.LocalDate;
import sibModel.PostSendFailed;
import sibModel.SendEmail;
import sibModel.SendSmtpEmail;
import sibModel.SendTemplateEmail;
import sibModel.SendTestEmail;
import sibModel.UpdateSmtpTemplate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalEmailsApi {
    private ApiClient apiClient;

    public TransactionalEmailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionalEmailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for blockNewDomain
     * @param blockDomain  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call blockNewDomainCall(BlockDomain blockDomain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = blockDomain;

        // create path and map variables
        String localVarPath = "/smtp/blockedDomains";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call blockNewDomainValidateBeforeCall(BlockDomain blockDomain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'blockDomain' is set
        if (blockDomain == null) {
            throw new ApiException("Missing the required parameter 'blockDomain' when calling blockNewDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = blockNewDomainCall(blockDomain, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new domain to the list of blocked domains
     * Blocks a new domain in order to avoid messages being sent to the same
     * @param blockDomain  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void blockNewDomain(BlockDomain blockDomain) throws ApiException {
        blockNewDomainWithHttpInfo(blockDomain);
    }

    /**
     * Add a new domain to the list of blocked domains
     * Blocks a new domain in order to avoid messages being sent to the same
     * @param blockDomain  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> blockNewDomainWithHttpInfo(BlockDomain blockDomain) throws ApiException {
        com.squareup.okhttp.Call call = blockNewDomainValidateBeforeCall(blockDomain, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a new domain to the list of blocked domains (asynchronously)
     * Blocks a new domain in order to avoid messages being sent to the same
     * @param blockDomain  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call blockNewDomainAsync(BlockDomain blockDomain, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = blockNewDomainValidateBeforeCall(blockDomain, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createSmtpTemplate
     * @param smtpTemplate values to update in transactional email template (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createSmtpTemplateCall(CreateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = smtpTemplate;

        // create path and map variables
        String localVarPath = "/smtp/templates";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createSmtpTemplateValidateBeforeCall(CreateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'smtpTemplate' is set
        if (smtpTemplate == null) {
            throw new ApiException("Missing the required parameter 'smtpTemplate' when calling createSmtpTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = createSmtpTemplateCall(smtpTemplate, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create an email template
     * 
     * @param smtpTemplate values to update in transactional email template (required)
     * @return CreateModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateModel createSmtpTemplate(CreateSmtpTemplate smtpTemplate) throws ApiException {
        ApiResponse<CreateModel> resp = createSmtpTemplateWithHttpInfo(smtpTemplate);
        return resp.getData();
    }

    /**
     * Create an email template
     * 
     * @param smtpTemplate values to update in transactional email template (required)
     * @return ApiResponse&lt;CreateModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateModel> createSmtpTemplateWithHttpInfo(CreateSmtpTemplate smtpTemplate) throws ApiException {
        com.squareup.okhttp.Call call = createSmtpTemplateValidateBeforeCall(smtpTemplate, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create an email template (asynchronously)
     * 
     * @param smtpTemplate values to update in transactional email template (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createSmtpTemplateAsync(CreateSmtpTemplate smtpTemplate, final ApiCallback<CreateModel> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createSmtpTemplateValidateBeforeCall(smtpTemplate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteBlockedDomain
     * @param domain The name of the domain to be deleted (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteBlockedDomainCall(String domain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/blockedDomains/{domain}"
            .replaceAll("\\{" + "domain" + "\\}", apiClient.escapeString(domain.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteBlockedDomainValidateBeforeCall(String domain, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'domain' is set
        if (domain == null) {
            throw new ApiException("Missing the required parameter 'domain' when calling deleteBlockedDomain(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteBlockedDomainCall(domain, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Unblock an existing domain from the list of blocked domains
     * Unblocks an existing domain from the list of blocked domains
     * @param domain The name of the domain to be deleted (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteBlockedDomain(String domain) throws ApiException {
        deleteBlockedDomainWithHttpInfo(domain);
    }

    /**
     * Unblock an existing domain from the list of blocked domains
     * Unblocks an existing domain from the list of blocked domains
     * @param domain The name of the domain to be deleted (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteBlockedDomainWithHttpInfo(String domain) throws ApiException {
        com.squareup.okhttp.Call call = deleteBlockedDomainValidateBeforeCall(domain, null, null);
        return apiClient.execute(call);
    }

    /**
     * Unblock an existing domain from the list of blocked domains (asynchronously)
     * Unblocks an existing domain from the list of blocked domains
     * @param domain The name of the domain to be deleted (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteBlockedDomainAsync(String domain, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteBlockedDomainValidateBeforeCall(domain, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteHardbounces
     * @param deleteHardbounces values to delete hardbounces (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteHardbouncesCall(DeleteHardbounces deleteHardbounces, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = deleteHardbounces;

        // create path and map variables
        String localVarPath = "/smtp/deleteHardbounces";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteHardbouncesValidateBeforeCall(DeleteHardbounces deleteHardbounces, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = deleteHardbouncesCall(deleteHardbounces, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete hardbounces
     * Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)
     * @param deleteHardbounces values to delete hardbounces (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteHardbounces(DeleteHardbounces deleteHardbounces) throws ApiException {
        deleteHardbouncesWithHttpInfo(deleteHardbounces);
    }

    /**
     * Delete hardbounces
     * Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)
     * @param deleteHardbounces values to delete hardbounces (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteHardbouncesWithHttpInfo(DeleteHardbounces deleteHardbounces) throws ApiException {
        com.squareup.okhttp.Call call = deleteHardbouncesValidateBeforeCall(deleteHardbounces, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete hardbounces (asynchronously)
     * Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)
     * @param deleteHardbounces values to delete hardbounces (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteHardbouncesAsync(DeleteHardbounces deleteHardbounces, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteHardbouncesValidateBeforeCall(deleteHardbounces, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteSmtpTemplate
     * @param templateId id of the template (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteSmtpTemplateCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/templates/{templateId}"
            .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteSmtpTemplateValidateBeforeCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling deleteSmtpTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteSmtpTemplateCall(templateId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an inactive email template
     * 
     * @param templateId id of the template (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteSmtpTemplate(Long templateId) throws ApiException {
        deleteSmtpTemplateWithHttpInfo(templateId);
    }

    /**
     * Delete an inactive email template
     * 
     * @param templateId id of the template (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteSmtpTemplateWithHttpInfo(Long templateId) throws ApiException {
        com.squareup.okhttp.Call call = deleteSmtpTemplateValidateBeforeCall(templateId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an inactive email template (asynchronously)
     * 
     * @param templateId id of the template (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteSmtpTemplateAsync(Long templateId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteSmtpTemplateValidateBeforeCall(templateId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getAggregatedSmtpReport
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAggregatedSmtpReportCall(String startDate, String endDate, Long days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/statistics/aggregatedReport";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAggregatedSmtpReportValidateBeforeCall(String startDate, String endDate, Long days, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getAggregatedSmtpReportCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get your transactional email activity aggregated over a period of time
     * 
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @return GetAggregatedReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetAggregatedReport getAggregatedSmtpReport(String startDate, String endDate, Long days, String tag) throws ApiException {
        ApiResponse<GetAggregatedReport> resp = getAggregatedSmtpReportWithHttpInfo(startDate, endDate, days, tag);
        return resp.getData();
    }

    /**
     * Get your transactional email activity aggregated over a period of time
     * 
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @return ApiResponse&lt;GetAggregatedReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetAggregatedReport> getAggregatedSmtpReportWithHttpInfo(String startDate, String endDate, Long days, String tag) throws ApiException {
        com.squareup.okhttp.Call call = getAggregatedSmtpReportValidateBeforeCall(startDate, endDate, days, tag, null, null);
        Type localVarReturnType = new TypeToken<GetAggregatedReport>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get your transactional email activity aggregated over a period of time (asynchronously)
     * 
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAggregatedSmtpReportAsync(String startDate, String endDate, Long days, String tag, final ApiCallback<GetAggregatedReport> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAggregatedSmtpReportValidateBeforeCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAggregatedReport>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getBlockedDomains
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getBlockedDomainsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/blockedDomains";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getBlockedDomainsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getBlockedDomainsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of blocked domains
     * Get the list of blocked domains
     * @return GetBlockedDomains
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetBlockedDomains getBlockedDomains() throws ApiException {
        ApiResponse<GetBlockedDomains> resp = getBlockedDomainsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get the list of blocked domains
     * Get the list of blocked domains
     * @return ApiResponse&lt;GetBlockedDomains&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetBlockedDomains> getBlockedDomainsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getBlockedDomainsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetBlockedDomains>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of blocked domains (asynchronously)
     * Get the list of blocked domains
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getBlockedDomainsAsync(final ApiCallback<GetBlockedDomains> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getBlockedDomainsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetBlockedDomains>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getEmailEventReport
     * @param limit Number limitation for the result returned (optional, default to 50)
     * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param email Filter the report for a specific email addresses (optional)
     * @param event Filter the report for a specific event type (optional)
     * @param tags Filter the report for tags (serialized and urlencoded array) (optional)
     * @param messageId Filter on a specific message id (optional)
     * @param templateId Filter on a specific template id (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getEmailEventReportCall(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/statistics/events";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (email != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("email", email));
        if (event != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("event", event));
        if (tags != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tags", tags));
        if (messageId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("messageId", messageId));
        if (templateId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getEmailEventReportValidateBeforeCall(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getEmailEventReportCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all your transactional email activity (unaggregated events)
     * 
     * @param limit Number limitation for the result returned (optional, default to 50)
     * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param email Filter the report for a specific email addresses (optional)
     * @param event Filter the report for a specific event type (optional)
     * @param tags Filter the report for tags (serialized and urlencoded array) (optional)
     * @param messageId Filter on a specific message id (optional)
     * @param templateId Filter on a specific template id (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return GetEmailEventReport
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetEmailEventReport getEmailEventReport(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort) throws ApiException {
        ApiResponse<GetEmailEventReport> resp = getEmailEventReportWithHttpInfo(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort);
        return resp.getData();
    }

    /**
     * Get all your transactional email activity (unaggregated events)
     * 
     * @param limit Number limitation for the result returned (optional, default to 50)
     * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param email Filter the report for a specific email addresses (optional)
     * @param event Filter the report for a specific event type (optional)
     * @param tags Filter the report for tags (serialized and urlencoded array) (optional)
     * @param messageId Filter on a specific message id (optional)
     * @param templateId Filter on a specific template id (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return ApiResponse&lt;GetEmailEventReport&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetEmailEventReport> getEmailEventReportWithHttpInfo(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getEmailEventReportValidateBeforeCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, null, null);
        Type localVarReturnType = new TypeToken<GetEmailEventReport>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all your transactional email activity (unaggregated events) (asynchronously)
     * 
     * @param limit Number limitation for the result returned (optional, default to 50)
     * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param email Filter the report for a specific email addresses (optional)
     * @param event Filter the report for a specific event type (optional)
     * @param tags Filter the report for tags (serialized and urlencoded array) (optional)
     * @param messageId Filter on a specific message id (optional)
     * @param templateId Filter on a specific template id (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getEmailEventReportAsync(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, final ApiCallback<GetEmailEventReport> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getEmailEventReportValidateBeforeCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetEmailEventReport>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSmtpReport
     * @param limit Number of documents returned per page (optional, default to 10)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD) (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD) (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSmtpReportCall(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/statistics/reports";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (days != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSmtpReportValidateBeforeCall(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getSmtpReportCall(limit, offset, startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get your transactional email activity aggregated per day
     * 
     * @param limit Number of documents returned per page (optional, default to 10)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD) (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD) (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return GetReports
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetReports getSmtpReport(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        ApiResponse<GetReports> resp = getSmtpReportWithHttpInfo(limit, offset, startDate, endDate, days, tag, sort);
        return resp.getData();
    }

    /**
     * Get your transactional email activity aggregated per day
     * 
     * @param limit Number of documents returned per page (optional, default to 10)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD) (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD) (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return ApiResponse&lt;GetReports&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetReports> getSmtpReportWithHttpInfo(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getSmtpReportValidateBeforeCall(limit, offset, startDate, endDate, days, tag, sort, null, null);
        Type localVarReturnType = new TypeToken<GetReports>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get your transactional email activity aggregated per day (asynchronously)
     * 
     * @param limit Number of documents returned per page (optional, default to 10)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param startDate Mandatory if endDate is used. Starting date of the report (YYYY-MM-DD) (optional)
     * @param endDate Mandatory if startDate is used. Ending date of the report (YYYY-MM-DD) (optional)
     * @param days Number of days in the past including today (positive integer). Not compatible with &#39;startDate&#39; and &#39;endDate&#39; (optional)
     * @param tag Tag of the emails (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSmtpReportAsync(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, final ApiCallback<GetReports> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSmtpReportValidateBeforeCall(limit, offset, startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetReports>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSmtpTemplate
     * @param templateId id of the template (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSmtpTemplateCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/templates/{templateId}"
            .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSmtpTemplateValidateBeforeCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getSmtpTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = getSmtpTemplateCall(templateId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Returns the template information
     * 
     * @param templateId id of the template (required)
     * @return GetSmtpTemplateOverview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSmtpTemplateOverview getSmtpTemplate(Long templateId) throws ApiException {
        ApiResponse<GetSmtpTemplateOverview> resp = getSmtpTemplateWithHttpInfo(templateId);
        return resp.getData();
    }

    /**
     * Returns the template information
     * 
     * @param templateId id of the template (required)
     * @return ApiResponse&lt;GetSmtpTemplateOverview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSmtpTemplateOverview> getSmtpTemplateWithHttpInfo(Long templateId) throws ApiException {
        com.squareup.okhttp.Call call = getSmtpTemplateValidateBeforeCall(templateId, null, null);
        Type localVarReturnType = new TypeToken<GetSmtpTemplateOverview>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Returns the template information (asynchronously)
     * 
     * @param templateId id of the template (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSmtpTemplateAsync(Long templateId, final ApiCallback<GetSmtpTemplateOverview> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSmtpTemplateValidateBeforeCall(templateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmtpTemplateOverview>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSmtpTemplates
     * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document in the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSmtpTemplatesCall(Boolean templateStatus, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/templates";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (templateStatus != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("templateStatus", templateStatus));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSmtpTemplatesValidateBeforeCall(Boolean templateStatus, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getSmtpTemplatesCall(templateStatus, limit, offset, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of email templates
     * 
     * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document in the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return GetSmtpTemplates
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetSmtpTemplates getSmtpTemplates(Boolean templateStatus, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetSmtpTemplates> resp = getSmtpTemplatesWithHttpInfo(templateStatus, limit, offset, sort);
        return resp.getData();
    }

    /**
     * Get the list of email templates
     * 
     * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document in the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return ApiResponse&lt;GetSmtpTemplates&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetSmtpTemplates> getSmtpTemplatesWithHttpInfo(Boolean templateStatus, Long limit, Long offset, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getSmtpTemplatesValidateBeforeCall(templateStatus, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetSmtpTemplates>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of email templates (asynchronously)
     * 
     * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document in the page (optional, default to 0)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSmtpTemplatesAsync(Boolean templateStatus, Long limit, Long offset, String sort, final ApiCallback<GetSmtpTemplates> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSmtpTemplatesValidateBeforeCall(templateStatus, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmtpTemplates>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransacBlockedContacts
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransacBlockedContactsCall(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/blockedContacts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (senders != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "senders", senders));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransacBlockedContactsValidateBeforeCall(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getTransacBlockedContactsCall(startDate, endDate, limit, offset, senders, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of blocked or unsubscribed transactional contacts
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return GetTransacBlockedContacts
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetTransacBlockedContacts getTransacBlockedContacts(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort) throws ApiException {
        ApiResponse<GetTransacBlockedContacts> resp = getTransacBlockedContactsWithHttpInfo(startDate, endDate, limit, offset, senders, sort);
        return resp.getData();
    }

    /**
     * Get the list of blocked or unsubscribed transactional contacts
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return ApiResponse&lt;GetTransacBlockedContacts&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetTransacBlockedContacts> getTransacBlockedContactsWithHttpInfo(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getTransacBlockedContactsValidateBeforeCall(startDate, endDate, limit, offset, senders, sort, null, null);
        Type localVarReturnType = new TypeToken<GetTransacBlockedContacts>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of blocked or unsubscribed transactional contacts (asynchronously)
     * 
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts (optional)
     * @param limit Number of documents returned per page (optional, default to 50)
     * @param offset Index of the first document on the page (optional, default to 0)
     * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransacBlockedContactsAsync(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, final ApiCallback<GetTransacBlockedContacts> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransacBlockedContactsValidateBeforeCall(startDate, endDate, limit, offset, senders, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacBlockedContacts>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransacEmailContent
     * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransacEmailContentCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/emails/{uuid}"
            .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(uuid.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransacEmailContentValidateBeforeCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getTransacEmailContent(Async)");
        }
        

        com.squareup.okhttp.Call call = getTransacEmailContentCall(uuid, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the personalized content of a sent transactional email
     * 
     * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
     * @return GetTransacEmailContent
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetTransacEmailContent getTransacEmailContent(String uuid) throws ApiException {
        ApiResponse<GetTransacEmailContent> resp = getTransacEmailContentWithHttpInfo(uuid);
        return resp.getData();
    }

    /**
     * Get the personalized content of a sent transactional email
     * 
     * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
     * @return ApiResponse&lt;GetTransacEmailContent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetTransacEmailContent> getTransacEmailContentWithHttpInfo(String uuid) throws ApiException {
        com.squareup.okhttp.Call call = getTransacEmailContentValidateBeforeCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<GetTransacEmailContent>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the personalized content of a sent transactional email (asynchronously)
     * 
     * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransacEmailContentAsync(String uuid, final ApiCallback<GetTransacEmailContent> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransacEmailContentValidateBeforeCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacEmailContent>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getTransacEmailsList
     * @param email Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent. (optional)
     * @param templateId Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email. (optional)
     * @param messageId Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTransacEmailsListCall(String email, Long templateId, String messageId, String startDate, String endDate, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (email != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("email", email));
        if (templateId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
        if (messageId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("messageId", messageId));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTransacEmailsListValidateBeforeCall(String email, Long templateId, String messageId, String startDate, String endDate, String sort, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getTransacEmailsListCall(email, templateId, messageId, startDate, endDate, sort, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the list of transactional emails on the basis of allowed filters
     * This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.
     * @param email Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent. (optional)
     * @param templateId Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email. (optional)
     * @param messageId Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return GetTransacEmailsList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetTransacEmailsList getTransacEmailsList(String email, Long templateId, String messageId, String startDate, String endDate, String sort) throws ApiException {
        ApiResponse<GetTransacEmailsList> resp = getTransacEmailsListWithHttpInfo(email, templateId, messageId, startDate, endDate, sort);
        return resp.getData();
    }

    /**
     * Get the list of transactional emails on the basis of allowed filters
     * This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.
     * @param email Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent. (optional)
     * @param templateId Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email. (optional)
     * @param messageId Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @return ApiResponse&lt;GetTransacEmailsList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetTransacEmailsList> getTransacEmailsListWithHttpInfo(String email, Long templateId, String messageId, String startDate, String endDate, String sort) throws ApiException {
        com.squareup.okhttp.Call call = getTransacEmailsListValidateBeforeCall(email, templateId, messageId, startDate, endDate, sort, null, null);
        Type localVarReturnType = new TypeToken<GetTransacEmailsList>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the list of transactional emails on the basis of allowed filters (asynchronously)
     * This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.
     * @param email Mandatory if templateId and messageId are not passed in query filters. Email address to which transactional email has been sent. (optional)
     * @param templateId Mandatory if email and messageId are not passed in query filters. Id of the template that was used to compose transactional email. (optional)
     * @param messageId Mandatory if templateId and email are not passed in query filters. Message ID of the transactional email sent. (optional)
     * @param startDate Mandatory if endDate is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param endDate Mandatory if startDate is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
     * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTransacEmailsListAsync(String email, Long templateId, String messageId, String startDate, String endDate, String sort, final ApiCallback<GetTransacEmailsList> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getTransacEmailsListValidateBeforeCall(email, templateId, messageId, startDate, endDate, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacEmailsList>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for sendTemplate
     * @param templateId Id of the template (required)
     * @param sendEmail  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call sendTemplateCall(Long templateId, SendEmail sendEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = sendEmail;

        // create path and map variables
        String localVarPath = "/smtp/templates/{templateId}/send"
            .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call sendTemplateValidateBeforeCall(Long templateId, SendEmail sendEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling sendTemplate(Async)");
        }
        
        // verify the required parameter 'sendEmail' is set
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling sendTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = sendTemplateCall(templateId, sendEmail, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Send a template
     * This endpoint is deprecated. Prefer v3/smtp/email instead.
     * @param templateId Id of the template (required)
     * @param sendEmail  (required)
     * @return SendTemplateEmail
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public SendTemplateEmail sendTemplate(Long templateId, SendEmail sendEmail) throws ApiException {
        ApiResponse<SendTemplateEmail> resp = sendTemplateWithHttpInfo(templateId, sendEmail);
        return resp.getData();
    }

    /**
     * Send a template
     * This endpoint is deprecated. Prefer v3/smtp/email instead.
     * @param templateId Id of the template (required)
     * @param sendEmail  (required)
     * @return ApiResponse&lt;SendTemplateEmail&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @deprecated
     */
    @Deprecated
    public ApiResponse<SendTemplateEmail> sendTemplateWithHttpInfo(Long templateId, SendEmail sendEmail) throws ApiException {
        com.squareup.okhttp.Call call = sendTemplateValidateBeforeCall(templateId, sendEmail, null, null);
        Type localVarReturnType = new TypeToken<SendTemplateEmail>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send a template (asynchronously)
     * This endpoint is deprecated. Prefer v3/smtp/email instead.
     * @param templateId Id of the template (required)
     * @param sendEmail  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @deprecated
     */
    @Deprecated
    public com.squareup.okhttp.Call sendTemplateAsync(Long templateId, SendEmail sendEmail, final ApiCallback<SendTemplateEmail> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendTemplateValidateBeforeCall(templateId, sendEmail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendTemplateEmail>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for sendTestTemplate
     * @param templateId Id of the template (required)
     * @param sendTestEmail  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call sendTestTemplateCall(Long templateId, SendTestEmail sendTestEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = sendTestEmail;

        // create path and map variables
        String localVarPath = "/smtp/templates/{templateId}/sendTest"
            .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call sendTestTemplateValidateBeforeCall(Long templateId, SendTestEmail sendTestEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling sendTestTemplate(Async)");
        }
        
        // verify the required parameter 'sendTestEmail' is set
        if (sendTestEmail == null) {
            throw new ApiException("Missing the required parameter 'sendTestEmail' when calling sendTestTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = sendTestTemplateCall(templateId, sendTestEmail, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Send a template to your test list
     * 
     * @param templateId Id of the template (required)
     * @param sendTestEmail  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void sendTestTemplate(Long templateId, SendTestEmail sendTestEmail) throws ApiException {
        sendTestTemplateWithHttpInfo(templateId, sendTestEmail);
    }

    /**
     * Send a template to your test list
     * 
     * @param templateId Id of the template (required)
     * @param sendTestEmail  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> sendTestTemplateWithHttpInfo(Long templateId, SendTestEmail sendTestEmail) throws ApiException {
        com.squareup.okhttp.Call call = sendTestTemplateValidateBeforeCall(templateId, sendTestEmail, null, null);
        return apiClient.execute(call);
    }

    /**
     * Send a template to your test list (asynchronously)
     * 
     * @param templateId Id of the template (required)
     * @param sendTestEmail  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendTestTemplateAsync(Long templateId, SendTestEmail sendTestEmail, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendTestTemplateValidateBeforeCall(templateId, sendTestEmail, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for sendTransacEmail
     * @param sendSmtpEmail Values to send a transactional email (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call sendTransacEmailCall(SendSmtpEmail sendSmtpEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = sendSmtpEmail;

        // create path and map variables
        String localVarPath = "/smtp/email";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call sendTransacEmailValidateBeforeCall(SendSmtpEmail sendSmtpEmail, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'sendSmtpEmail' is set
        if (sendSmtpEmail == null) {
            throw new ApiException("Missing the required parameter 'sendSmtpEmail' when calling sendTransacEmail(Async)");
        }
        

        com.squareup.okhttp.Call call = sendTransacEmailCall(sendSmtpEmail, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Send a transactional email
     * 
     * @param sendSmtpEmail Values to send a transactional email (required)
     * @return CreateSmtpEmail
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateSmtpEmail sendTransacEmail(SendSmtpEmail sendSmtpEmail) throws ApiException {
        ApiResponse<CreateSmtpEmail> resp = sendTransacEmailWithHttpInfo(sendSmtpEmail);
        return resp.getData();
    }

    /**
     * Send a transactional email
     * 
     * @param sendSmtpEmail Values to send a transactional email (required)
     * @return ApiResponse&lt;CreateSmtpEmail&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateSmtpEmail> sendTransacEmailWithHttpInfo(SendSmtpEmail sendSmtpEmail) throws ApiException {
        com.squareup.okhttp.Call call = sendTransacEmailValidateBeforeCall(sendSmtpEmail, null, null);
        Type localVarReturnType = new TypeToken<CreateSmtpEmail>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send a transactional email (asynchronously)
     * 
     * @param sendSmtpEmail Values to send a transactional email (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendTransacEmailAsync(SendSmtpEmail sendSmtpEmail, final ApiCallback<CreateSmtpEmail> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendTransacEmailValidateBeforeCall(sendSmtpEmail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateSmtpEmail>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for smtpBlockedContactsEmailDelete
     * @param email contact email (urlencoded) to unblock. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call smtpBlockedContactsEmailDeleteCall(String email, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/blockedContacts/{email}"
            .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(email.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call smtpBlockedContactsEmailDeleteValidateBeforeCall(String email, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling smtpBlockedContactsEmailDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = smtpBlockedContactsEmailDeleteCall(email, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Unblock or resubscribe a transactional contact
     * 
     * @param email contact email (urlencoded) to unblock. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void smtpBlockedContactsEmailDelete(String email) throws ApiException {
        smtpBlockedContactsEmailDeleteWithHttpInfo(email);
    }

    /**
     * Unblock or resubscribe a transactional contact
     * 
     * @param email contact email (urlencoded) to unblock. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> smtpBlockedContactsEmailDeleteWithHttpInfo(String email) throws ApiException {
        com.squareup.okhttp.Call call = smtpBlockedContactsEmailDeleteValidateBeforeCall(email, null, null);
        return apiClient.execute(call);
    }

    /**
     * Unblock or resubscribe a transactional contact (asynchronously)
     * 
     * @param email contact email (urlencoded) to unblock. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call smtpBlockedContactsEmailDeleteAsync(String email, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = smtpBlockedContactsEmailDeleteValidateBeforeCall(email, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for smtpLogMessageIdDelete
     * @param messageId MessageId of the transactional log to delete (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call smtpLogMessageIdDeleteCall(String messageId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/smtp/log/{messageId}"
            .replaceAll("\\{" + "messageId" + "\\}", apiClient.escapeString(messageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call smtpLogMessageIdDeleteValidateBeforeCall(String messageId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'messageId' is set
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling smtpLogMessageIdDelete(Async)");
        }
        

        com.squareup.okhttp.Call call = smtpLogMessageIdDeleteCall(messageId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an SMTP transactional log
     * 
     * @param messageId MessageId of the transactional log to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void smtpLogMessageIdDelete(String messageId) throws ApiException {
        smtpLogMessageIdDeleteWithHttpInfo(messageId);
    }

    /**
     * Delete an SMTP transactional log
     * 
     * @param messageId MessageId of the transactional log to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> smtpLogMessageIdDeleteWithHttpInfo(String messageId) throws ApiException {
        com.squareup.okhttp.Call call = smtpLogMessageIdDeleteValidateBeforeCall(messageId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an SMTP transactional log (asynchronously)
     * 
     * @param messageId MessageId of the transactional log to delete (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call smtpLogMessageIdDeleteAsync(String messageId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = smtpLogMessageIdDeleteValidateBeforeCall(messageId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateSmtpTemplate
     * @param templateId id of the template (required)
     * @param smtpTemplate values to update in transactional email template (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateSmtpTemplateCall(Long templateId, UpdateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = smtpTemplate;

        // create path and map variables
        String localVarPath = "/smtp/templates/{templateId}"
            .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "api-key", "partner-key" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateSmtpTemplateValidateBeforeCall(Long templateId, UpdateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling updateSmtpTemplate(Async)");
        }
        
        // verify the required parameter 'smtpTemplate' is set
        if (smtpTemplate == null) {
            throw new ApiException("Missing the required parameter 'smtpTemplate' when calling updateSmtpTemplate(Async)");
        }
        

        com.squareup.okhttp.Call call = updateSmtpTemplateCall(templateId, smtpTemplate, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update an email template
     * 
     * @param templateId id of the template (required)
     * @param smtpTemplate values to update in transactional email template (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateSmtpTemplate(Long templateId, UpdateSmtpTemplate smtpTemplate) throws ApiException {
        updateSmtpTemplateWithHttpInfo(templateId, smtpTemplate);
    }

    /**
     * Update an email template
     * 
     * @param templateId id of the template (required)
     * @param smtpTemplate values to update in transactional email template (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateSmtpTemplateWithHttpInfo(Long templateId, UpdateSmtpTemplate smtpTemplate) throws ApiException {
        com.squareup.okhttp.Call call = updateSmtpTemplateValidateBeforeCall(templateId, smtpTemplate, null, null);
        return apiClient.execute(call);
    }

    /**
     * Update an email template (asynchronously)
     * 
     * @param templateId id of the template (required)
     * @param smtpTemplate values to update in transactional email template (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateSmtpTemplateAsync(Long templateId, UpdateSmtpTemplate smtpTemplate, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateSmtpTemplateValidateBeforeCall(templateId, smtpTemplate, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
