/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.BlockDomain;
import sibModel.CreateModel;
import sibModel.CreateSmtpEmail;
import sibModel.CreateSmtpTemplate;
import sibModel.DeleteHardbounces;
import sibModel.GetAggregatedReport;
import sibModel.GetBlockedDomains;
import sibModel.GetEmailEventReport;
import sibModel.GetReports;
import sibModel.GetSmtpTemplateOverview;
import sibModel.GetSmtpTemplates;
import sibModel.GetTransacBlockedContacts;
import sibModel.GetTransacEmailContent;
import sibModel.GetTransacEmailsList;
import sibModel.SendEmail;
import sibModel.SendSmtpEmail;
import sibModel.SendTemplateEmail;
import sibModel.SendTestEmail;
import sibModel.UpdateSmtpTemplate;

public class TransactionalEmailsApi {
    private ApiClient apiClient;

    public TransactionalEmailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionalEmailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call blockNewDomainCall(BlockDomain blockDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BlockDomain localVarPostBody = blockDomain;
        String localVarPath = "/smtp/blockedDomains";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call blockNewDomainValidateBeforeCall(BlockDomain blockDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (blockDomain == null) {
            throw new ApiException("Missing the required parameter 'blockDomain' when calling blockNewDomain(Async)");
        }
        Call call = this.blockNewDomainCall(blockDomain, progressListener, progressRequestListener);
        return call;
    }

    public void blockNewDomain(BlockDomain blockDomain) throws ApiException {
        this.blockNewDomainWithHttpInfo(blockDomain);
    }

    public ApiResponse<Void> blockNewDomainWithHttpInfo(BlockDomain blockDomain) throws ApiException {
        Call call = this.blockNewDomainValidateBeforeCall(blockDomain, null, null);
        return this.apiClient.execute(call);
    }

    public Call blockNewDomainAsync(BlockDomain blockDomain, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.blockNewDomainValidateBeforeCall(blockDomain, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createSmtpTemplateCall(CreateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateSmtpTemplate localVarPostBody = smtpTemplate;
        String localVarPath = "/smtp/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSmtpTemplateValidateBeforeCall(CreateSmtpTemplate smtpTemplate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (smtpTemplate == null) {
            throw new ApiException("Missing the required parameter 'smtpTemplate' when calling createSmtpTemplate(Async)");
        }
        Call call = this.createSmtpTemplateCall(smtpTemplate, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createSmtpTemplate(CreateSmtpTemplate smtpTemplate) throws ApiException {
        ApiResponse<CreateModel> resp = this.createSmtpTemplateWithHttpInfo(smtpTemplate);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createSmtpTemplateWithHttpInfo(CreateSmtpTemplate smtpTemplate) throws ApiException {
        Call call = this.createSmtpTemplateValidateBeforeCall(smtpTemplate, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSmtpTemplateAsync(CreateSmtpTemplate smtpTemplate, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSmtpTemplateValidateBeforeCall(smtpTemplate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteBlockedDomainCall(String domain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedDomains/{domain}".replaceAll("\\{domain\\}", this.apiClient.escapeString(domain.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteBlockedDomainValidateBeforeCall(String domain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (domain == null) {
            throw new ApiException("Missing the required parameter 'domain' when calling deleteBlockedDomain(Async)");
        }
        Call call = this.deleteBlockedDomainCall(domain, progressListener, progressRequestListener);
        return call;
    }

    public void deleteBlockedDomain(String domain) throws ApiException {
        this.deleteBlockedDomainWithHttpInfo(domain);
    }

    public ApiResponse<Void> deleteBlockedDomainWithHttpInfo(String domain) throws ApiException {
        Call call = this.deleteBlockedDomainValidateBeforeCall(domain, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteBlockedDomainAsync(String domain, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteBlockedDomainValidateBeforeCall(domain, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteHardbouncesCall(DeleteHardbounces deleteHardbounces, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeleteHardbounces localVarPostBody = deleteHardbounces;
        String localVarPath = "/smtp/deleteHardbounces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteHardbouncesValidateBeforeCall(DeleteHardbounces deleteHardbounces, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.deleteHardbouncesCall(deleteHardbounces, progressListener, progressRequestListener);
        return call;
    }

    public void deleteHardbounces(DeleteHardbounces deleteHardbounces) throws ApiException {
        this.deleteHardbouncesWithHttpInfo(deleteHardbounces);
    }

    public ApiResponse<Void> deleteHardbouncesWithHttpInfo(DeleteHardbounces deleteHardbounces) throws ApiException {
        Call call = this.deleteHardbouncesValidateBeforeCall(deleteHardbounces, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteHardbouncesAsync(DeleteHardbounces deleteHardbounces, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteHardbouncesValidateBeforeCall(deleteHardbounces, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteSmtpTemplateCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSmtpTemplateValidateBeforeCall(Long templateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling deleteSmtpTemplate(Async)");
        }
        Call call = this.deleteSmtpTemplateCall(templateId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteSmtpTemplate(Long templateId) throws ApiException {
        this.deleteSmtpTemplateWithHttpInfo(templateId);
    }

    public ApiResponse<Void> deleteSmtpTemplateWithHttpInfo(Long templateId) throws ApiException {
        Call call = this.deleteSmtpTemplateValidateBeforeCall(templateId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteSmtpTemplateAsync(Long templateId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSmtpTemplateValidateBeforeCall(templateId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getAggregatedSmtpReportCall(String startDate, String endDate, Long days, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/aggregatedReport";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAggregatedSmtpReportValidateBeforeCall(String startDate, String endDate, Long days, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAggregatedSmtpReportCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        return call;
    }

    public GetAggregatedReport getAggregatedSmtpReport(String startDate, String endDate, Long days, String tag) throws ApiException {
        ApiResponse<GetAggregatedReport> resp = this.getAggregatedSmtpReportWithHttpInfo(startDate, endDate, days, tag);
        return resp.getData();
    }

    public ApiResponse<GetAggregatedReport> getAggregatedSmtpReportWithHttpInfo(String startDate, String endDate, Long days, String tag) throws ApiException {
        Call call = this.getAggregatedSmtpReportValidateBeforeCall(startDate, endDate, days, tag, null, null);
        Type localVarReturnType = new TypeToken<GetAggregatedReport>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAggregatedSmtpReportAsync(String startDate, String endDate, Long days, String tag, final ApiCallback<GetAggregatedReport> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAggregatedSmtpReportValidateBeforeCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAggregatedReport>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getBlockedDomainsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedDomains";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getBlockedDomainsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getBlockedDomainsCall(progressListener, progressRequestListener);
        return call;
    }

    public GetBlockedDomains getBlockedDomains() throws ApiException {
        ApiResponse<GetBlockedDomains> resp = this.getBlockedDomainsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<GetBlockedDomains> getBlockedDomainsWithHttpInfo() throws ApiException {
        Call call = this.getBlockedDomainsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetBlockedDomains>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getBlockedDomainsAsync(final ApiCallback<GetBlockedDomains> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getBlockedDomainsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetBlockedDomains>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEmailEventReportCall(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        }
        if (event != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("event", event));
        }
        if (tags != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tags", tags));
        }
        if (messageId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("messageId", messageId));
        }
        if (templateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEmailEventReportValidateBeforeCall(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEmailEventReportCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetEmailEventReport getEmailEventReport(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort) throws ApiException {
        ApiResponse<GetEmailEventReport> resp = this.getEmailEventReportWithHttpInfo(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort);
        return resp.getData();
    }

    public ApiResponse<GetEmailEventReport> getEmailEventReportWithHttpInfo(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort) throws ApiException {
        Call call = this.getEmailEventReportValidateBeforeCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, null, null);
        Type localVarReturnType = new TypeToken<GetEmailEventReport>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEmailEventReportAsync(Long limit, Long offset, String startDate, String endDate, Long days, String email, String event, String tags, String messageId, Long templateId, String sort, final ApiCallback<GetEmailEventReport> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEmailEventReportValidateBeforeCall(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetEmailEventReport>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSmtpReportCall(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/statistics/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmtpReportValidateBeforeCall(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSmtpReportCall(limit, offset, startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetReports getSmtpReport(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        ApiResponse<GetReports> resp = this.getSmtpReportWithHttpInfo(limit, offset, startDate, endDate, days, tag, sort);
        return resp.getData();
    }

    public ApiResponse<GetReports> getSmtpReportWithHttpInfo(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        Call call = this.getSmtpReportValidateBeforeCall(limit, offset, startDate, endDate, days, tag, sort, null, null);
        Type localVarReturnType = new TypeToken<GetReports>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmtpReportAsync(Long limit, Long offset, String startDate, String endDate, Long days, String tag, String sort, final ApiCallback<GetReports> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmtpReportValidateBeforeCall(limit, offset, startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetReports>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSmtpTemplateCall(Long templateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmtpTemplateValidateBeforeCall(Long templateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getSmtpTemplate(Async)");
        }
        Call call = this.getSmtpTemplateCall(templateId, progressListener, progressRequestListener);
        return call;
    }

    public GetSmtpTemplateOverview getSmtpTemplate(Long templateId) throws ApiException {
        ApiResponse<GetSmtpTemplateOverview> resp = this.getSmtpTemplateWithHttpInfo(templateId);
        return resp.getData();
    }

    public ApiResponse<GetSmtpTemplateOverview> getSmtpTemplateWithHttpInfo(Long templateId) throws ApiException {
        Call call = this.getSmtpTemplateValidateBeforeCall(templateId, null, null);
        Type localVarReturnType = new TypeToken<GetSmtpTemplateOverview>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmtpTemplateAsync(Long templateId, final ApiCallback<GetSmtpTemplateOverview> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmtpTemplateValidateBeforeCall(templateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmtpTemplateOverview>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSmtpTemplatesCall(Boolean templateStatus, Long limit, Long offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (templateStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("templateStatus", templateStatus));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmtpTemplatesValidateBeforeCall(Boolean templateStatus, Long limit, Long offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSmtpTemplatesCall(templateStatus, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetSmtpTemplates getSmtpTemplates(Boolean templateStatus, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<GetSmtpTemplates> resp = this.getSmtpTemplatesWithHttpInfo(templateStatus, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<GetSmtpTemplates> getSmtpTemplatesWithHttpInfo(Boolean templateStatus, Long limit, Long offset, String sort) throws ApiException {
        Call call = this.getSmtpTemplatesValidateBeforeCall(templateStatus, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<GetSmtpTemplates>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmtpTemplatesAsync(Boolean templateStatus, Long limit, Long offset, String sort, final ApiCallback<GetSmtpTemplates> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmtpTemplatesValidateBeforeCall(templateStatus, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmtpTemplates>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransacBlockedContactsCall(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedContacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (senders != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "senders", senders));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransacBlockedContactsValidateBeforeCall(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTransacBlockedContactsCall(startDate, endDate, limit, offset, senders, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetTransacBlockedContacts getTransacBlockedContacts(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort) throws ApiException {
        ApiResponse<GetTransacBlockedContacts> resp = this.getTransacBlockedContactsWithHttpInfo(startDate, endDate, limit, offset, senders, sort);
        return resp.getData();
    }

    public ApiResponse<GetTransacBlockedContacts> getTransacBlockedContactsWithHttpInfo(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort) throws ApiException {
        Call call = this.getTransacBlockedContactsValidateBeforeCall(startDate, endDate, limit, offset, senders, sort, null, null);
        Type localVarReturnType = new TypeToken<GetTransacBlockedContacts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransacBlockedContactsAsync(String startDate, String endDate, Long limit, Long offset, List<String> senders, String sort, final ApiCallback<GetTransacBlockedContacts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransacBlockedContactsValidateBeforeCall(startDate, endDate, limit, offset, senders, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacBlockedContacts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransacEmailContentCall(String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/emails/{uuid}".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransacEmailContentValidateBeforeCall(String uuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getTransacEmailContent(Async)");
        }
        Call call = this.getTransacEmailContentCall(uuid, progressListener, progressRequestListener);
        return call;
    }

    public GetTransacEmailContent getTransacEmailContent(String uuid) throws ApiException {
        ApiResponse<GetTransacEmailContent> resp = this.getTransacEmailContentWithHttpInfo(uuid);
        return resp.getData();
    }

    public ApiResponse<GetTransacEmailContent> getTransacEmailContentWithHttpInfo(String uuid) throws ApiException {
        Call call = this.getTransacEmailContentValidateBeforeCall(uuid, null, null);
        Type localVarReturnType = new TypeToken<GetTransacEmailContent>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransacEmailContentAsync(String uuid, final ApiCallback<GetTransacEmailContent> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransacEmailContentValidateBeforeCall(uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacEmailContent>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransacEmailsListCall(String email, Long templateId, String messageId, String startDate, String endDate, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/emails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        }
        if (templateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        }
        if (messageId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("messageId", messageId));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransacEmailsListValidateBeforeCall(String email, Long templateId, String messageId, String startDate, String endDate, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTransacEmailsListCall(email, templateId, messageId, startDate, endDate, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetTransacEmailsList getTransacEmailsList(String email, Long templateId, String messageId, String startDate, String endDate, String sort) throws ApiException {
        ApiResponse<GetTransacEmailsList> resp = this.getTransacEmailsListWithHttpInfo(email, templateId, messageId, startDate, endDate, sort);
        return resp.getData();
    }

    public ApiResponse<GetTransacEmailsList> getTransacEmailsListWithHttpInfo(String email, Long templateId, String messageId, String startDate, String endDate, String sort) throws ApiException {
        Call call = this.getTransacEmailsListValidateBeforeCall(email, templateId, messageId, startDate, endDate, sort, null, null);
        Type localVarReturnType = new TypeToken<GetTransacEmailsList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransacEmailsListAsync(String email, Long templateId, String messageId, String startDate, String endDate, String sort, final ApiCallback<GetTransacEmailsList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransacEmailsListValidateBeforeCall(email, templateId, messageId, startDate, endDate, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacEmailsList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Deprecated
    public Call sendTemplateCall(Long templateId, SendEmail sendEmail, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendEmail localVarPostBody = sendEmail;
        String localVarPath = "/smtp/templates/{templateId}/send".replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call sendTemplateValidateBeforeCall(Long templateId, SendEmail sendEmail, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling sendTemplate(Async)");
        }
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling sendTemplate(Async)");
        }
        Call call = this.sendTemplateCall(templateId, sendEmail, progressListener, progressRequestListener);
        return call;
    }

    @Deprecated
    public SendTemplateEmail sendTemplate(Long templateId, SendEmail sendEmail) throws ApiException {
        ApiResponse<SendTemplateEmail> resp = this.sendTemplateWithHttpInfo(templateId, sendEmail);
        return resp.getData();
    }

    @Deprecated
    public ApiResponse<SendTemplateEmail> sendTemplateWithHttpInfo(Long templateId, SendEmail sendEmail) throws ApiException {
        Call call = this.sendTemplateValidateBeforeCall(templateId, sendEmail, null, null);
        Type localVarReturnType = new TypeToken<SendTemplateEmail>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    @Deprecated
    public Call sendTemplateAsync(Long templateId, SendEmail sendEmail, final ApiCallback<SendTemplateEmail> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTemplateValidateBeforeCall(templateId, sendEmail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendTemplateEmail>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call sendTestTemplateCall(Long templateId, SendTestEmail sendTestEmail, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendTestEmail localVarPostBody = sendTestEmail;
        String localVarPath = "/smtp/templates/{templateId}/sendTest".replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendTestTemplateValidateBeforeCall(Long templateId, SendTestEmail sendTestEmail, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling sendTestTemplate(Async)");
        }
        if (sendTestEmail == null) {
            throw new ApiException("Missing the required parameter 'sendTestEmail' when calling sendTestTemplate(Async)");
        }
        Call call = this.sendTestTemplateCall(templateId, sendTestEmail, progressListener, progressRequestListener);
        return call;
    }

    public void sendTestTemplate(Long templateId, SendTestEmail sendTestEmail) throws ApiException {
        this.sendTestTemplateWithHttpInfo(templateId, sendTestEmail);
    }

    public ApiResponse<Void> sendTestTemplateWithHttpInfo(Long templateId, SendTestEmail sendTestEmail) throws ApiException {
        Call call = this.sendTestTemplateValidateBeforeCall(templateId, sendTestEmail, null, null);
        return this.apiClient.execute(call);
    }

    public Call sendTestTemplateAsync(Long templateId, SendTestEmail sendTestEmail, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTestTemplateValidateBeforeCall(templateId, sendTestEmail, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call sendTransacEmailCall(SendSmtpEmail sendSmtpEmail, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendSmtpEmail localVarPostBody = sendSmtpEmail;
        String localVarPath = "/smtp/email";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendTransacEmailValidateBeforeCall(SendSmtpEmail sendSmtpEmail, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sendSmtpEmail == null) {
            throw new ApiException("Missing the required parameter 'sendSmtpEmail' when calling sendTransacEmail(Async)");
        }
        Call call = this.sendTransacEmailCall(sendSmtpEmail, progressListener, progressRequestListener);
        return call;
    }

    public CreateSmtpEmail sendTransacEmail(SendSmtpEmail sendSmtpEmail) throws ApiException {
        ApiResponse<CreateSmtpEmail> resp = this.sendTransacEmailWithHttpInfo(sendSmtpEmail);
        return resp.getData();
    }

    public ApiResponse<CreateSmtpEmail> sendTransacEmailWithHttpInfo(SendSmtpEmail sendSmtpEmail) throws ApiException {
        Call call = this.sendTransacEmailValidateBeforeCall(sendSmtpEmail, null, null);
        Type localVarReturnType = new TypeToken<CreateSmtpEmail>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendTransacEmailAsync(SendSmtpEmail sendSmtpEmail, final ApiCallback<CreateSmtpEmail> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTransacEmailValidateBeforeCall(sendSmtpEmail, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateSmtpEmail>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call smtpBlockedContactsEmailDeleteCall(String email, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/blockedContacts/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(email.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smtpBlockedContactsEmailDeleteValidateBeforeCall(String email, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling smtpBlockedContactsEmailDelete(Async)");
        }
        Call call = this.smtpBlockedContactsEmailDeleteCall(email, progressListener, progressRequestListener);
        return call;
    }

    public void smtpBlockedContactsEmailDelete(String email) throws ApiException {
        this.smtpBlockedContactsEmailDeleteWithHttpInfo(email);
    }

    public ApiResponse<Void> smtpBlockedContactsEmailDeleteWithHttpInfo(String email) throws ApiException {
        Call call = this.smtpBlockedContactsEmailDeleteValidateBeforeCall(email, null, null);
        return this.apiClient.execute(call);
    }

    public Call smtpBlockedContactsEmailDeleteAsync(String email, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smtpBlockedContactsEmailDeleteValidateBeforeCall(email, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call smtpLogMessageIdDeleteCall(String messageId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/smtp/log/{messageId}".replaceAll("\\{messageId\\}", this.apiClient.escapeString(messageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call smtpLogMessageIdDeleteValidateBeforeCall(String messageId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling smtpLogMessageIdDelete(Async)");
        }
        Call call = this.smtpLogMessageIdDeleteCall(messageId, progressListener, progressRequestListener);
        return call;
    }

    public void smtpLogMessageIdDelete(String messageId) throws ApiException {
        this.smtpLogMessageIdDeleteWithHttpInfo(messageId);
    }

    public ApiResponse<Void> smtpLogMessageIdDeleteWithHttpInfo(String messageId) throws ApiException {
        Call call = this.smtpLogMessageIdDeleteValidateBeforeCall(messageId, null, null);
        return this.apiClient.execute(call);
    }

    public Call smtpLogMessageIdDeleteAsync(String messageId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.smtpLogMessageIdDeleteValidateBeforeCall(messageId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateSmtpTemplateCall(Long templateId, UpdateSmtpTemplate smtpTemplate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateSmtpTemplate localVarPostBody = smtpTemplate;
        String localVarPath = "/smtp/templates/{templateId}".replaceAll("\\{templateId\\}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateSmtpTemplateValidateBeforeCall(Long templateId, UpdateSmtpTemplate smtpTemplate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling updateSmtpTemplate(Async)");
        }
        if (smtpTemplate == null) {
            throw new ApiException("Missing the required parameter 'smtpTemplate' when calling updateSmtpTemplate(Async)");
        }
        Call call = this.updateSmtpTemplateCall(templateId, smtpTemplate, progressListener, progressRequestListener);
        return call;
    }

    public void updateSmtpTemplate(Long templateId, UpdateSmtpTemplate smtpTemplate) throws ApiException {
        this.updateSmtpTemplateWithHttpInfo(templateId, smtpTemplate);
    }

    public ApiResponse<Void> updateSmtpTemplateWithHttpInfo(Long templateId, UpdateSmtpTemplate smtpTemplate) throws ApiException {
        Call call = this.updateSmtpTemplateValidateBeforeCall(templateId, smtpTemplate, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateSmtpTemplateAsync(Long templateId, UpdateSmtpTemplate smtpTemplate, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateSmtpTemplateValidateBeforeCall(templateId, smtpTemplate, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

