/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Email sending credentials including subject, body, to, cc etc.")
public class SendReportEmail {
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="to")
    private List<String> to = null;
    @SerializedName(value="contentType")
    private ContentTypeEnum contentType = null;
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    @SerializedName(value="cc")
    private List<String> cc = null;
    @SerializedName(value="body")
    private String body = null;

    public SendReportEmail subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="Report of the last campaign", value="Subject of the email message")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SendReportEmail to(List<String> to) {
        this.to = to;
        return this;
    }

    public SendReportEmail addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @ApiModelProperty(value="Email addresses of the recipients")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public SendReportEmail contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="html", value="Type of the message body")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public SendReportEmail bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public SendReportEmail addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @ApiModelProperty(value="Email addresses of the recipients in bcc")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public SendReportEmail cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public SendReportEmail addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @ApiModelProperty(value="Email addresses of the recipients in cc")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public SendReportEmail body(String body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="Please find attached the report of our last email campaign.", value="Body of the email message")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendReportEmail sendReportEmail = (SendReportEmail)o;
        return ObjectUtils.equals((Object)this.subject, (Object)sendReportEmail.subject) && ObjectUtils.equals(this.to, sendReportEmail.to) && ObjectUtils.equals((Object)((Object)this.contentType), (Object)((Object)sendReportEmail.contentType)) && ObjectUtils.equals(this.bcc, sendReportEmail.bcc) && ObjectUtils.equals(this.cc, sendReportEmail.cc) && ObjectUtils.equals((Object)this.body, (Object)sendReportEmail.body);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.subject, this.to, this.contentType, this.bcc, this.cc, this.body});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendReportEmail {\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentTypeEnum {
        TEXT("text"),
        HTML("html");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentTypeEnum fromValue(String text) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ContentTypeEnum> {
            public void write(JsonWriter jsonWriter, ContentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

