/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import sibModel.RequestContactImportNewList;

public class RequestContactImport {
    @SerializedName(value="fileUrl")
    private String fileUrl = null;
    @SerializedName(value="fileBody")
    private String fileBody = null;
    @SerializedName(value="listIds")
    private List<Long> listIds = null;
    @SerializedName(value="notifyUrl")
    private String notifyUrl = null;
    @SerializedName(value="newList")
    private RequestContactImportNewList newList = null;
    @SerializedName(value="emailBlacklist")
    private Boolean emailBlacklist = false;
    @SerializedName(value="smsBlacklist")
    private Boolean smsBlacklist = false;
    @SerializedName(value="updateExistingContacts")
    private Boolean updateExistingContacts = true;

    public RequestContactImport fileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    @ApiModelProperty(example="https://importfile.domain.com", value="Mandatory if fileBody is not defined. URL of the file to be imported (no local file). Possible file formats: .txt, .csv")
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public RequestContactImport fileBody(String fileBody) {
        this.fileBody = fileBody;
        return this;
    }

    @ApiModelProperty(example="NAME;SURNAME;EMAIL\\n\"Smith\";\"John\";\"john.smith@example.com\"\\n\"Roger\";\"Ellie\";\"ellie36@example.com", value="Mandatory if fileUrl is not defined. CSV content to be imported. Use semicolon to separate multiple attributes")
    public String getFileBody() {
        return this.fileBody;
    }

    public void setFileBody(String fileBody) {
        this.fileBody = fileBody;
    }

    public RequestContactImport listIds(List<Long> listIds) {
        this.listIds = listIds;
        return this;
    }

    public RequestContactImport addListIdsItem(Long listIdsItem) {
        if (this.listIds == null) {
            this.listIds = new ArrayList<Long>();
        }
        this.listIds.add(listIdsItem);
        return this;
    }

    @ApiModelProperty(value="Mandatory if newList is not defined. Ids of the lists in which the contacts shall be imported. For example, [2, 4, 7].")
    public List<Long> getListIds() {
        return this.listIds;
    }

    public void setListIds(List<Long> listIds) {
        this.listIds = listIds;
    }

    public RequestContactImport notifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", value="URL that will be called once the export process is finished")
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public RequestContactImport newList(RequestContactImportNewList newList) {
        this.newList = newList;
        return this;
    }

    @ApiModelProperty(value="")
    public RequestContactImportNewList getNewList() {
        return this.newList;
    }

    public void setNewList(RequestContactImportNewList newList) {
        this.newList = newList;
    }

    public RequestContactImport emailBlacklist(Boolean emailBlacklist) {
        this.emailBlacklist = emailBlacklist;
        return this;
    }

    @ApiModelProperty(example="false", value="To blacklist all the contacts for email")
    public Boolean isEmailBlacklist() {
        return this.emailBlacklist;
    }

    public void setEmailBlacklist(Boolean emailBlacklist) {
        this.emailBlacklist = emailBlacklist;
    }

    public RequestContactImport smsBlacklist(Boolean smsBlacklist) {
        this.smsBlacklist = smsBlacklist;
        return this;
    }

    @ApiModelProperty(example="false", value="To blacklist all the contacts for sms")
    public Boolean isSmsBlacklist() {
        return this.smsBlacklist;
    }

    public void setSmsBlacklist(Boolean smsBlacklist) {
        this.smsBlacklist = smsBlacklist;
    }

    public RequestContactImport updateExistingContacts(Boolean updateExistingContacts) {
        this.updateExistingContacts = updateExistingContacts;
        return this;
    }

    @ApiModelProperty(example="true", value="To facilitate the choice to update the existing contacts")
    public Boolean isUpdateExistingContacts() {
        return this.updateExistingContacts;
    }

    public void setUpdateExistingContacts(Boolean updateExistingContacts) {
        this.updateExistingContacts = updateExistingContacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestContactImport requestContactImport = (RequestContactImport)o;
        return ObjectUtils.equals((Object)this.fileUrl, (Object)requestContactImport.fileUrl) && ObjectUtils.equals((Object)this.fileBody, (Object)requestContactImport.fileBody) && ObjectUtils.equals(this.listIds, requestContactImport.listIds) && ObjectUtils.equals((Object)this.notifyUrl, (Object)requestContactImport.notifyUrl) && ObjectUtils.equals((Object)this.newList, (Object)requestContactImport.newList) && ObjectUtils.equals((Object)this.emailBlacklist, (Object)requestContactImport.emailBlacklist) && ObjectUtils.equals((Object)this.smsBlacklist, (Object)requestContactImport.smsBlacklist) && ObjectUtils.equals((Object)this.updateExistingContacts, (Object)requestContactImport.updateExistingContacts);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.fileUrl, this.fileBody, this.listIds, this.notifyUrl, this.newList, this.emailBlacklist, this.smsBlacklist, this.updateExistingContacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestContactImport {\n");
        sb.append("    fileUrl: ").append(this.toIndentedString(this.fileUrl)).append("\n");
        sb.append("    fileBody: ").append(this.toIndentedString(this.fileBody)).append("\n");
        sb.append("    listIds: ").append(this.toIndentedString(this.listIds)).append("\n");
        sb.append("    notifyUrl: ").append(this.toIndentedString(this.notifyUrl)).append("\n");
        sb.append("    newList: ").append(this.toIndentedString(this.newList)).append("\n");
        sb.append("    emailBlacklist: ").append(this.toIndentedString(this.emailBlacklist)).append("\n");
        sb.append("    smsBlacklist: ").append(this.toIndentedString(this.smsBlacklist)).append("\n");
        sb.append("    updateExistingContacts: ").append(this.toIndentedString(this.updateExistingContacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

