/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.apache.commons.lang3.ObjectUtils;
import org.threeten.bp.OffsetDateTime;

public class GetEmailEventReportEvents {
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="date")
    private OffsetDateTime date = null;
    @SerializedName(value="subject")
    private String subject = null;
    @SerializedName(value="messageId")
    private String messageId = null;
    @SerializedName(value="event")
    private EventEnum event = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="ip")
    private String ip = null;
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="from")
    private String from = null;

    public GetEmailEventReportEvents email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="john.smith@example.com", required=true, value="Email address which generates the event")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public GetEmailEventReportEvents date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="2017-03-12T12:30:00Z", required=true, value="UTC date-time on which the event has been generated")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public GetEmailEventReportEvents subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="Sib client test", value="Subject of the event")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public GetEmailEventReportEvents messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="<201798300811.5787683@relay.domain.com>", required=true, value="Message ID which generated the event")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public GetEmailEventReportEvents event(EventEnum event) {
        this.event = event;
        return this;
    }

    @ApiModelProperty(example="delivered", required=true, value="Event which occurred")
    public EventEnum getEvent() {
        return this.event;
    }

    public void setEvent(EventEnum event) {
        this.event = event;
    }

    public GetEmailEventReportEvents reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="Error connection timeout", value="Reason of bounce (only available if the event is hardbounce or softbounce)")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public GetEmailEventReportEvents tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(example="OrderConfirmation", value="Tag of the email which generated the event")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public GetEmailEventReportEvents ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(example="165.87.3.15", value="IP from which the user has opened the email or clicked on the link (only available if the event is opened or clicks)")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public GetEmailEventReportEvents link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(example="https://www.someexamplelink.com", value="The link which is sent to the user (only available if the event is requests or opened or clicks)")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public GetEmailEventReportEvents from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="john@example.com", value="Sender email from which the emails are sent")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetEmailEventReportEvents getEmailEventReportEvents = (GetEmailEventReportEvents)o;
        return ObjectUtils.equals((Object)this.email, (Object)getEmailEventReportEvents.email) && ObjectUtils.equals((Object)this.date, (Object)getEmailEventReportEvents.date) && ObjectUtils.equals((Object)this.subject, (Object)getEmailEventReportEvents.subject) && ObjectUtils.equals((Object)this.messageId, (Object)getEmailEventReportEvents.messageId) && ObjectUtils.equals((Object)((Object)this.event), (Object)((Object)getEmailEventReportEvents.event)) && ObjectUtils.equals((Object)this.reason, (Object)getEmailEventReportEvents.reason) && ObjectUtils.equals((Object)this.tag, (Object)getEmailEventReportEvents.tag) && ObjectUtils.equals((Object)this.ip, (Object)getEmailEventReportEvents.ip) && ObjectUtils.equals((Object)this.link, (Object)getEmailEventReportEvents.link) && ObjectUtils.equals((Object)this.from, (Object)getEmailEventReportEvents.from);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.email, this.date, this.subject, this.messageId, this.event, this.reason, this.tag, this.ip, this.link, this.from});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetEmailEventReportEvents {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    event: ").append(this.toIndentedString((Object)this.event)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventEnum {
        BOUNCES("bounces"),
        HARDBOUNCES("hardBounces"),
        SOFTBOUNCES("softBounces"),
        DELIVERED("delivered"),
        SPAM("spam"),
        REQUESTS("requests"),
        OPENED("opened"),
        CLICKS("clicks"),
        INVALID("invalid"),
        DEFERRED("deferred"),
        BLOCKED("blocked");

        private String value;

        private EventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventEnum fromValue(String text) {
            for (EventEnum b : EventEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventEnum> {
            public void write(JsonWriter jsonWriter, EventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

