/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.threeten.bp.OffsetDateTime;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.AddContactToList;
import sibModel.CreateList;
import sibModel.CreateModel;
import sibModel.GetContacts;
import sibModel.GetExtendedList;
import sibModel.GetFolderLists;
import sibModel.GetLists;
import sibModel.PostContactInfo;
import sibModel.RemoveContactFromList;
import sibModel.UpdateList;

public class ListsApi {
    private ApiClient apiClient;

    public ListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addContactToListCall(Long listId, AddContactToList contactEmails, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddContactToList localVarPostBody = contactEmails;
        String localVarPath = "/contacts/lists/{listId}/contacts/add".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addContactToListValidateBeforeCall(Long listId, AddContactToList contactEmails, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling addContactToList(Async)");
        }
        if (contactEmails == null) {
            throw new ApiException("Missing the required parameter 'contactEmails' when calling addContactToList(Async)");
        }
        Call call = this.addContactToListCall(listId, contactEmails, progressListener, progressRequestListener);
        return call;
    }

    public PostContactInfo addContactToList(Long listId, AddContactToList contactEmails) throws ApiException {
        ApiResponse<PostContactInfo> resp = this.addContactToListWithHttpInfo(listId, contactEmails);
        return resp.getData();
    }

    public ApiResponse<PostContactInfo> addContactToListWithHttpInfo(Long listId, AddContactToList contactEmails) throws ApiException {
        Call call = this.addContactToListValidateBeforeCall(listId, contactEmails, null, null);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addContactToListAsync(Long listId, AddContactToList contactEmails, final ApiCallback<PostContactInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addContactToListValidateBeforeCall(listId, contactEmails, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createListCall(CreateList createList, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateList localVarPostBody = createList;
        String localVarPath = "/contacts/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createListValidateBeforeCall(CreateList createList, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createList == null) {
            throw new ApiException("Missing the required parameter 'createList' when calling createList(Async)");
        }
        Call call = this.createListCall(createList, progressListener, progressRequestListener);
        return call;
    }

    public CreateModel createList(CreateList createList) throws ApiException {
        ApiResponse<CreateModel> resp = this.createListWithHttpInfo(createList);
        return resp.getData();
    }

    public ApiResponse<CreateModel> createListWithHttpInfo(CreateList createList) throws ApiException {
        Call call = this.createListValidateBeforeCall(createList, null, null);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createListAsync(CreateList createList, final ApiCallback<CreateModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createListValidateBeforeCall(createList, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteListCall(Long listId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteListValidateBeforeCall(Long listId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling deleteList(Async)");
        }
        Call call = this.deleteListCall(listId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteList(Long listId) throws ApiException {
        this.deleteListWithHttpInfo(listId);
    }

    public ApiResponse<Void> deleteListWithHttpInfo(Long listId) throws ApiException {
        Call call = this.deleteListValidateBeforeCall(listId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteListAsync(Long listId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteListValidateBeforeCall(listId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getContactsFromListCall(Long listId, OffsetDateTime modifiedSince, Long limit, Long offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}/contacts".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (modifiedSince != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("modifiedSince", modifiedSince));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContactsFromListValidateBeforeCall(Long listId, OffsetDateTime modifiedSince, Long limit, Long offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling getContactsFromList(Async)");
        }
        Call call = this.getContactsFromListCall(listId, modifiedSince, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public GetContacts getContactsFromList(Long listId, OffsetDateTime modifiedSince, Long limit, Long offset) throws ApiException {
        ApiResponse<GetContacts> resp = this.getContactsFromListWithHttpInfo(listId, modifiedSince, limit, offset);
        return resp.getData();
    }

    public ApiResponse<GetContacts> getContactsFromListWithHttpInfo(Long listId, OffsetDateTime modifiedSince, Long limit, Long offset) throws ApiException {
        Call call = this.getContactsFromListValidateBeforeCall(listId, modifiedSince, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContactsFromListAsync(Long listId, OffsetDateTime modifiedSince, Long limit, Long offset, final ApiCallback<GetContacts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContactsFromListValidateBeforeCall(listId, modifiedSince, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetContacts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFolderListsCall(Long folderId, Long limit, Long offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/folders/{folderId}/lists".replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFolderListsValidateBeforeCall(Long folderId, Long limit, Long offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (folderId == null) {
            throw new ApiException("Missing the required parameter 'folderId' when calling getFolderLists(Async)");
        }
        Call call = this.getFolderListsCall(folderId, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public GetFolderLists getFolderLists(Long folderId, Long limit, Long offset) throws ApiException {
        ApiResponse<GetFolderLists> resp = this.getFolderListsWithHttpInfo(folderId, limit, offset);
        return resp.getData();
    }

    public ApiResponse<GetFolderLists> getFolderListsWithHttpInfo(Long folderId, Long limit, Long offset) throws ApiException {
        Call call = this.getFolderListsValidateBeforeCall(folderId, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<GetFolderLists>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFolderListsAsync(Long folderId, Long limit, Long offset, final ApiCallback<GetFolderLists> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFolderListsValidateBeforeCall(folderId, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetFolderLists>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListCall(Long listId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListValidateBeforeCall(Long listId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling getList(Async)");
        }
        Call call = this.getListCall(listId, progressListener, progressRequestListener);
        return call;
    }

    public GetExtendedList getList(Long listId) throws ApiException {
        ApiResponse<GetExtendedList> resp = this.getListWithHttpInfo(listId);
        return resp.getData();
    }

    public ApiResponse<GetExtendedList> getListWithHttpInfo(Long listId) throws ApiException {
        Call call = this.getListValidateBeforeCall(listId, null, null);
        Type localVarReturnType = new TypeToken<GetExtendedList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListAsync(Long listId, final ApiCallback<GetExtendedList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListValidateBeforeCall(listId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetExtendedList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getListsCall(Long limit, Long offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getListsValidateBeforeCall(Long limit, Long offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getListsCall(limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public GetLists getLists(Long limit, Long offset) throws ApiException {
        ApiResponse<GetLists> resp = this.getListsWithHttpInfo(limit, offset);
        return resp.getData();
    }

    public ApiResponse<GetLists> getListsWithHttpInfo(Long limit, Long offset) throws ApiException {
        Call call = this.getListsValidateBeforeCall(limit, offset, null, null);
        Type localVarReturnType = new TypeToken<GetLists>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getListsAsync(Long limit, Long offset, final ApiCallback<GetLists> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getListsValidateBeforeCall(limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetLists>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeContactFromListCall(Long listId, RemoveContactFromList contactEmails, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemoveContactFromList localVarPostBody = contactEmails;
        String localVarPath = "/contacts/lists/{listId}/contacts/remove".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeContactFromListValidateBeforeCall(Long listId, RemoveContactFromList contactEmails, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling removeContactFromList(Async)");
        }
        if (contactEmails == null) {
            throw new ApiException("Missing the required parameter 'contactEmails' when calling removeContactFromList(Async)");
        }
        Call call = this.removeContactFromListCall(listId, contactEmails, progressListener, progressRequestListener);
        return call;
    }

    public PostContactInfo removeContactFromList(Long listId, RemoveContactFromList contactEmails) throws ApiException {
        ApiResponse<PostContactInfo> resp = this.removeContactFromListWithHttpInfo(listId, contactEmails);
        return resp.getData();
    }

    public ApiResponse<PostContactInfo> removeContactFromListWithHttpInfo(Long listId, RemoveContactFromList contactEmails) throws ApiException {
        Call call = this.removeContactFromListValidateBeforeCall(listId, contactEmails, null, null);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeContactFromListAsync(Long listId, RemoveContactFromList contactEmails, final ApiCallback<PostContactInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeContactFromListValidateBeforeCall(listId, contactEmails, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContactInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateListCall(Long listId, UpdateList updateList, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateList localVarPostBody = updateList;
        String localVarPath = "/contacts/lists/{listId}".replaceAll("\\{listId\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateListValidateBeforeCall(Long listId, UpdateList updateList, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (listId == null) {
            throw new ApiException("Missing the required parameter 'listId' when calling updateList(Async)");
        }
        if (updateList == null) {
            throw new ApiException("Missing the required parameter 'updateList' when calling updateList(Async)");
        }
        Call call = this.updateListCall(listId, updateList, progressListener, progressRequestListener);
        return call;
    }

    public void updateList(Long listId, UpdateList updateList) throws ApiException {
        this.updateListWithHttpInfo(listId, updateList);
    }

    public ApiResponse<Void> updateListWithHttpInfo(Long listId, UpdateList updateList) throws ApiException {
        Call call = this.updateListValidateBeforeCall(listId, updateList, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateListAsync(Long listId, UpdateList updateList, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateListValidateBeforeCall(listId, updateList, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

