/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.webhooks;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.webhooks.models.EventWebhookTestRequest;
import com.sendgrid.util.JsonUtil;

public class TestEventWebhook
extends ApiKeyBase {
    private String onBehalfOf;
    private EventWebhookTestRequest eventWebhookTestRequest;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/user/webhooks/event/test";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TestEventWebhook creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.eventWebhookTestRequest != null) {
            request.addBody(JsonUtil.toJson(this.eventWebhookTestRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setEventWebhookTestRequest(EventWebhookTestRequest eventWebhookTestRequest) {
        this.eventWebhookTestRequest = eventWebhookTestRequest;
    }
}

