/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.templates;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.templates.models.TransactionalTemplate;
import com.sendgrid.util.JsonUtil;

public class GetTemplate
extends ApiKeyBase {
    private final String templateId;
    private String onBehalfOf;

    @Override
    public ApiResponse<TransactionalTemplate> send(ApiKeyRestClient client) {
        String path = "/v3/templates/{template_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetTemplate creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<TransactionalTemplate>(statusCode, JsonUtil.fromJson(response.getStream(), TransactionalTemplate.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.templateId != null) {
            request.addPathParam("template_id", this.templateId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public GetTemplate(String templateId) {
        this.templateId = templateId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

