/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.templates;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.util.JsonUtil;
import java.util.UUID;

public class DeleteTemplateVersion
extends ApiKeyBase {
    private final UUID templateId;
    private final UUID versionId;
    private String onBehalfOf;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/templates/{template_id}/versions/{version_id}";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteTemplateVersion creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.templateId != null) {
            request.addPathParam("template_id", this.templateId.toString());
        }
        if (this.versionId != null) {
            request.addPathParam("version_id", this.versionId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public DeleteTemplateVersion(UUID templateId, UUID versionId) {
        this.templateId = templateId;
        this.versionId = versionId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

