/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.suppressions;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.suppressions.models.Accept;
import com.sendgrid.rest.api.v3.suppressions.models.ErrorResponse;
import com.sendgrid.rest.api.v3.suppressions.models.ListSuppressionBouncesClassifications200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListSuppressionBouncesClassifications
extends ApiKeyBase {
    private String startDate;
    private String endDate;
    private final Accept accept;
    private String onBehalfOf;

    @Override
    public ApiResponse<ListSuppressionBouncesClassifications200Response> send(ApiKeyRestClient client) {
        String path = "/v3/suppression/bounces/classifications";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSuppressionBouncesClassifications creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListSuppressionBouncesClassifications200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListSuppressionBouncesClassifications200Response.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.accept != null) {
            request.addHeaderParam("Accept", this.accept.toString());
        }
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
    }

    public ListSuppressionBouncesClassifications(Accept accept) {
        this.accept = accept;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

