/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.suppressions;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.suppressions.models.SuppressionGroup;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class ListAsmGroup
extends ApiKeyBase {
    private Integer id;
    private String onBehalfOf;

    @Override
    public ApiResponse<List<SuppressionGroup>> send(ApiKeyRestClient client) {
        String path = "/v3/asm/groups";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListAsmGroup creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<SuppressionGroup>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.id != null) {
            request.addQueryParam("id", this.id.toString());
        }
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

