/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.suppressions;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.suppressions.models.AddSuppressionToAsmGroup201Response;
import com.sendgrid.rest.api.v3.suppressions.models.SuppressionsRequest;
import com.sendgrid.util.JsonUtil;

public class AddSuppressionToAsmGroup
extends ApiKeyBase {
    private final String groupId;
    private String onBehalfOf;
    private SuppressionsRequest suppressionsRequest;

    @Override
    public ApiResponse<AddSuppressionToAsmGroup201Response> send(ApiKeyRestClient client) {
        String path = "/v3/asm/groups/{group_id}/suppressions";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddSuppressionToAsmGroup creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AddSuppressionToAsmGroup201Response>(statusCode, JsonUtil.fromJson(response.getStream(), AddSuppressionToAsmGroup201Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.groupId != null) {
            request.addPathParam("group_id", this.groupId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.suppressionsRequest != null) {
            request.addBody(JsonUtil.toJson(this.suppressionsRequest));
        }
    }

    public AddSuppressionToAsmGroup(String groupId) {
        this.groupId = groupId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setSuppressionsRequest(SuppressionsRequest suppressionsRequest) {
        this.suppressionsRequest = suppressionsRequest;
    }
}

