/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.subusers;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.subusers.models.ErrorResponse;
import com.sendgrid.rest.api.v3.subusers.models.UpdateSubuserIp200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class UpdateSubuserIp
extends ApiKeyBase {
    private final String subuserName;
    private List<String> requestBody;

    @Override
    public ApiResponse<UpdateSubuserIp200Response> send(ApiKeyRestClient client) {
        String path = "/v3/subusers/{subuser_name}/ips";
        Request request = new Request(HttpMethod.PUT, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSubuserIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<UpdateSubuserIp200Response>(statusCode, JsonUtil.fromJson(response.getStream(), UpdateSubuserIp200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.subuserName != null) {
            request.addPathParam("subuser_name", this.subuserName.toString());
        }
    }

    private void addBody(Request request) {
        if (this.requestBody != null) {
            request.addBody(JsonUtil.toJson(this.requestBody));
        }
    }

    public UpdateSubuserIp(String subuserName) {
        this.subuserName = subuserName;
    }

    public void setRequestBody(List<String> requestBody) {
        this.requestBody = requestBody;
    }
}

