/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.stats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.stats.models.AggregatedBy;
import com.sendgrid.rest.api.v3.stats.models.CategoryStats;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class ListCategoryStat
extends ApiKeyBase {
    private final String startDate;
    private String endDate;
    private final String categories;
    private AggregatedBy aggregatedBy;
    private String onBehalfOf;

    @Override
    public ApiResponse<List<CategoryStats>> send(ApiKeyRestClient client) {
        String path = "/v3/categories/stats";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListCategoryStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<CategoryStats>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
        if (this.categories != null) {
            request.addQueryParam("categories", this.categories.toString());
        }
        if (this.aggregatedBy != null) {
            request.addQueryParam("aggregated_by", this.aggregatedBy.toString());
        }
    }

    public ListCategoryStat(String startDate, String categories) {
        this.startDate = startDate;
        this.categories = categories;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setAggregatedBy(AggregatedBy aggregatedBy) {
        this.aggregatedBy = aggregatedBy;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

