/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.stats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.stats.models.AggregatedBy3;
import com.sendgrid.rest.api.v3.stats.models.ListBrowserStat200ResponseInner;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class ListBrowserStat
extends ApiKeyBase {
    private String browsers;
    private Integer limit;
    private Integer offset;
    private AggregatedBy3 aggregatedBy;
    private final String startDate;
    private String endDate;
    private String onBehalfOf;

    @Override
    public ApiResponse<List<ListBrowserStat200ResponseInner>> send(ApiKeyRestClient client) {
        String path = "/v3/browsers/stats";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListBrowserStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<ListBrowserStat200ResponseInner>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.browsers != null) {
            request.addQueryParam("browsers", this.browsers.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
        if (this.aggregatedBy != null) {
            request.addQueryParam("aggregated_by", this.aggregatedBy.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
    }

    public ListBrowserStat(String startDate) {
        this.startDate = startDate;
    }

    public void setBrowsers(String browsers) {
        this.browsers = browsers;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setAggregatedBy(AggregatedBy3 aggregatedBy) {
        this.aggregatedBy = aggregatedBy;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

