/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.sso;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.sso.models.PostPatchIntegrationRequest;
import com.sendgrid.rest.api.v3.sso.models.SsoErrorResponseInner;
import com.sendgrid.rest.api.v3.sso.models.SsoIntegration;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class UpdateSsoIntegration
extends ApiKeyBase {
    private final String id;
    private Boolean si;
    private PostPatchIntegrationRequest postPatchIntegrationRequest;

    @Override
    public ApiResponse<SsoIntegration> send(ApiKeyRestClient client) {
        String path = "/v3/sso/integrations/{id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateSsoIntegration creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                TypeReference<List<SsoErrorResponseInner>> listTypeReference = new TypeReference<List<SsoErrorResponseInner>>(){};
                List<SsoErrorResponseInner> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                TypeReference<List<SsoErrorResponseInner>> listTypeReference = new TypeReference<List<SsoErrorResponseInner>>(){};
                List<SsoErrorResponseInner> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                TypeReference<List<SsoErrorResponseInner>> listTypeReference = new TypeReference<List<SsoErrorResponseInner>>(){};
                List<SsoErrorResponseInner> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "429")) {
                TypeReference<List<SsoErrorResponseInner>> listTypeReference = new TypeReference<List<SsoErrorResponseInner>>(){};
                List<SsoErrorResponseInner> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                TypeReference<List<SsoErrorResponseInner>> listTypeReference = new TypeReference<List<SsoErrorResponseInner>>(){};
                List<SsoErrorResponseInner> error = JsonUtil.fromJson(response.getStream(), listTypeReference);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SsoIntegration>(statusCode, JsonUtil.fromJson(response.getStream(), SsoIntegration.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.si != null) {
            request.addQueryParam("si", this.si.toString());
        }
    }

    private void addBody(Request request) {
        if (this.postPatchIntegrationRequest != null) {
            request.addBody(JsonUtil.toJson(this.postPatchIntegrationRequest));
        }
    }

    public UpdateSsoIntegration(String id) {
        this.id = id;
    }

    public void setSi(Boolean si) {
        this.si = si;
    }

    public void setPostPatchIntegrationRequest(PostPatchIntegrationRequest postPatchIntegrationRequest) {
        this.postPatchIntegrationRequest = postPatchIntegrationRequest;
    }
}

