/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcstats;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcstats.models.AggregatedBy;
import com.sendgrid.rest.api.v3.mcstats.models.AutomationsResponse;
import com.sendgrid.rest.api.v3.mcstats.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mcstats.models.Items;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;

public class GetAutomationStat
extends ApiKeyBase {
    private final String id;
    private List<Items> groupBy;
    private List<UUID> stepIds;
    private AggregatedBy aggregatedBy;
    private LocalDate startDate;
    private LocalDate endDate;
    private String timezone;
    private Integer pageSize;
    private String pageToken;

    @Override
    public ApiResponse<AutomationsResponse> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/stats/automations/{id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetAutomationStat creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AutomationsResponse>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.groupBy != null) {
            request.addQueryParam("group_by", this.groupBy.toString());
        }
        if (this.stepIds != null) {
            request.addQueryParam("step_ids", this.stepIds.toString());
        }
        if (this.aggregatedBy != null) {
            request.addQueryParam("aggregated_by", this.aggregatedBy.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("start_date", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("end_date", this.endDate.toString());
        }
        if (this.timezone != null) {
            request.addQueryParam("timezone", this.timezone.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
    }

    public GetAutomationStat(String id) {
        this.id = id;
    }

    public void setGroupBy(List<Items> groupBy) {
        this.groupBy = groupBy;
    }

    public void setStepIds(List<UUID> stepIds) {
        this.stepIds = stepIds;
    }

    public void setAggregatedBy(AggregatedBy aggregatedBy) {
        this.aggregatedBy = aggregatedBy;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }
}

