/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsenders;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsenders.models.ErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ResetSenderVerification
extends ApiKeyBase {
    private final Integer id;
    private String onBehalfOf;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/senders/{id}/resend_verification";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ResetSenderVerification creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public ResetSenderVerification(Integer id) {
        this.id = id;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

