/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcsegments2;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcsegments2.models.SegmentError;
import com.sendgrid.rest.api.v3.mcsegments2.models.SegmentRefresh202;
import com.sendgrid.rest.api.v3.mcsegments2.models.SegmentRefreshRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.UUID;

public class RefreshSegment
extends ApiKeyBase {
    private final UUID segmentId;
    private SegmentRefreshRequest segmentRefreshRequest;

    @Override
    public ApiResponse<SegmentRefresh202> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/segments/2.0/refresh/{segment_id}";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RefreshSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                SegmentError error = JsonUtil.fromJson(response.getStream(), SegmentError.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                SegmentError error = JsonUtil.fromJson(response.getStream(), SegmentError.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SegmentRefresh202>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.segmentId != null) {
            request.addPathParam("segment_id", this.segmentId.toString());
        }
    }

    private void addBody(Request request) {
        if (this.segmentRefreshRequest != null) {
            request.addBody(JsonUtil.toJson(this.segmentRefreshRequest));
        }
    }

    public RefreshSegment(UUID segmentId) {
        this.segmentId = segmentId;
    }

    public void setSegmentRefreshRequest(SegmentRefreshRequest segmentRefreshRequest) {
        this.segmentRefreshRequest = segmentRefreshRequest;
    }
}

