/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mclists;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mclists.models.ListMarketingList200Response;
import com.sendgrid.util.JsonUtil;
import java.math.BigDecimal;

public class ListMarketingList
extends ApiKeyBase {
    private BigDecimal pageSize;
    private String pageToken;

    @Override
    public ApiResponse<ListMarketingList200Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/lists";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListMarketingList creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListMarketingList200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListMarketingList200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("page_size", this.pageSize.toString());
        }
        if (this.pageToken != null) {
            request.addQueryParam("page_token", this.pageToken.toString());
        }
    }

    public void setPageSize(BigDecimal pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }
}

