/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mcdesigns;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mcdesigns.models.ApiErrors;
import com.sendgrid.rest.api.v3.mcdesigns.models.DesignOutput;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.UUID;

public class GetPreBuiltDesign
extends ApiKeyBase {
    private final UUID id;

    @Override
    public ApiResponse<DesignOutput> send(ApiKeyRestClient client) {
        String path = "/v3/designs/pre-builts/{id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetPreBuiltDesign creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ApiErrors error = JsonUtil.fromJson(response.getStream(), ApiErrors.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ApiErrors error = JsonUtil.fromJson(response.getStream(), ApiErrors.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<DesignOutput>(statusCode, JsonUtil.fromJson(response.getStream(), DesignOutput.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    public GetPreBuiltDesign(UUID id) {
        this.id = id;
    }
}

