/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccustomfields;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccustomfields.models.CreateFieldDefinition400Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteFieldDefinition
extends ApiKeyBase {
    private final String customFieldId;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/field_definitions/{custom_field_id}";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteFieldDefinition creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                CreateFieldDefinition400Response error = JsonUtil.fromJson(response.getStream(), CreateFieldDefinition400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.customFieldId != null) {
            request.addPathParam("custom_field_id", this.customFieldId.toString());
        }
    }

    public DeleteFieldDefinition(String customFieldId) {
        this.customFieldId = customFieldId;
    }
}

