/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mccontacts;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mccontacts.models.DeleteContact400Response;
import com.sendgrid.rest.api.v3.mccontacts.models.DeleteContactIdentifier202Response;
import com.sendgrid.rest.api.v3.mccontacts.models.DeleteContactIdentifierRequest;
import com.sendgrid.rest.api.v3.mccontacts.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mccontacts.models.SearchContact500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteContactIdentifier
extends ApiKeyBase {
    private final String contactId;
    private DeleteContactIdentifierRequest deleteContactIdentifierRequest;

    @Override
    public ApiResponse<DeleteContactIdentifier202Response> send(ApiKeyRestClient client) {
        String path = "/v3/marketing/contacts/{contact_id}/identifiers";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteContactIdentifier creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                DeleteContact400Response error = JsonUtil.fromJson(response.getStream(), DeleteContact400Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                SearchContact500Response error = JsonUtil.fromJson(response.getStream(), SearchContact500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<DeleteContactIdentifier202Response>(statusCode, JsonUtil.fromJson(response.getStream(), DeleteContactIdentifier202Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.contactId != null) {
            request.addPathParam("contact_id", this.contactId.toString());
        }
    }

    private void addBody(Request request) {
        if (this.deleteContactIdentifierRequest != null) {
            request.addBody(JsonUtil.toJson(this.deleteContactIdentifierRequest));
        }
    }

    public DeleteContactIdentifier(String contactId) {
        this.contactId = contactId;
    }

    public void setDeleteContactIdentifierRequest(DeleteContactIdentifierRequest deleteContactIdentifierRequest) {
        this.deleteContactIdentifierRequest = deleteContactIdentifierRequest;
    }
}

