/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mailsettings;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mailsettings.models.MailSettingsAddressWhitelabel200;
import com.sendgrid.rest.api.v3.mailsettings.models.UpdateAddressWhitelistRequest;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class UpdateAddressWhitelist
extends ApiKeyBase {
    private String onBehalfOf;
    private UpdateAddressWhitelistRequest updateAddressWhitelistRequest;

    @Override
    public ApiResponse<MailSettingsAddressWhitelabel200> send(ApiKeyRestClient client) {
        String path = "/v3/mail_settings/address_whitelist";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateAddressWhitelist creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<MailSettingsAddressWhitelabel200>(statusCode, JsonUtil.fromJson(response.getStream(), MailSettingsAddressWhitelabel200.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateAddressWhitelistRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateAddressWhitelistRequest));
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setUpdateAddressWhitelistRequest(UpdateAddressWhitelistRequest updateAddressWhitelistRequest) {
        this.updateAddressWhitelistRequest = updateAddressWhitelistRequest;
    }
}

