/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.mail;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.mail.models.ErrorResponse;
import com.sendgrid.rest.api.v3.mail.models.MailBatchResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class GetMailBatch
extends ApiKeyBase {
    private String onBehalfOf;

    @Override
    public ApiResponse<MailBatchResponse> send(ApiKeyRestClient client) {
        String path = "/v3/mail/batch/{batch_id}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetMailBatch creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "405")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<MailBatchResponse>(statusCode, JsonUtil.fromJson(response.getStream(), MailBatchResponse.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

