/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccontactdb;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.SearchRecipient200Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.SearchRecipientRequest;
import com.sendgrid.util.JsonUtil;

public class SearchRecipient
extends ApiKeyBase {
    private SearchRecipientRequest searchRecipientRequest;

    @Override
    public ApiResponse<SearchRecipient200Response> send(ApiKeyRestClient client) {
        String path = "/v3/contactdb/recipients/search";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SearchRecipient creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<SearchRecipient200Response>(statusCode, response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.searchRecipientRequest != null) {
            request.addBody(JsonUtil.toJson(this.searchRecipientRequest));
        }
    }

    public void setSearchRecipientRequest(SearchRecipientRequest searchRecipientRequest) {
        this.searchRecipientRequest = searchRecipientRequest;
    }
}

