/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccontactdb;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ErrorResponse;
import com.sendgrid.rest.api.v3.lmccontactdb.models.ListAllSegmentsResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListSegment
extends ApiKeyBase {
    private String onBehalfOf;

    @Override
    public ApiResponse<ListAllSegmentsResponse> send(ApiKeyRestClient client) {
        String path = "/v3/contactdb/segments";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSegment creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListAllSegmentsResponse>(statusCode, JsonUtil.fromJson(response.getStream(), ListAllSegmentsResponse.class), response.getHeaders());
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

