/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.lmccampaigns;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.lmccampaigns.models.ErrorResponse;
import com.sendgrid.rest.api.v3.lmccampaigns.models.ScheduleACampaignRequest;
import com.sendgrid.rest.api.v3.lmccampaigns.models.ScheduleACampaignResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ScheduleCampaign
extends ApiKeyBase {
    private final Integer campaignId;
    private String onBehalfOf;
    private ScheduleACampaignRequest scheduleACampaignRequest;

    @Override
    public ApiResponse<ScheduleACampaignResponse> send(ApiKeyRestClient client) {
        String path = "/v3/campaigns/{campaign_id}/schedules";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ScheduleCampaign creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                ErrorResponse error = JsonUtil.fromJson(response.getStream(), ErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ScheduleACampaignResponse>(statusCode, JsonUtil.fromJson(response.getStream(), ScheduleACampaignResponse.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.campaignId != null) {
            request.addPathParam("campaign_id", this.campaignId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.scheduleACampaignRequest != null) {
            request.addBody(JsonUtil.toJson(this.scheduleACampaignRequest));
        }
    }

    public ScheduleCampaign(Integer campaignId) {
        this.campaignId = campaignId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setScheduleACampaignRequest(ScheduleACampaignRequest scheduleACampaignRequest) {
        this.scheduleACampaignRequest = scheduleACampaignRequest;
    }
}

