/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipwarmup;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipwarmup.models.GetWarmUpIp404Response;
import com.sendgrid.rest.api.v3.ipwarmup.models.IpWarmup200Inner;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;
import java.util.List;

public class GetWarmUpIp
extends ApiKeyBase {
    private final String ipAddress;

    @Override
    public ApiResponse<List<IpWarmup200Inner>> send(ApiKeyRestClient client) {
        String path = "/v3/ips/warmup/{ip_address}";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("GetWarmUpIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                GetWarmUpIp404Response error = JsonUtil.fromJson(response.getStream(), GetWarmUpIp404Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<IpWarmup200Inner>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.ipAddress != null) {
            request.addPathParam("ip_address", this.ipAddress.toString());
        }
    }

    public GetWarmUpIp(String ipAddress) {
        this.ipAddress = ipAddress;
    }
}

