/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ips;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ips.models.ListIp200ResponseInner;
import com.sendgrid.rest.api.v3.ips.models.SortByDirection;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class ListIp
extends ApiKeyBase {
    private String ip;
    private Boolean excludeWhitelabels;
    private Integer limit;
    private Integer offset;
    private String subuser;
    private SortByDirection sortByDirection;

    @Override
    public ApiResponse<List<ListIp200ResponseInner>> send(ApiKeyRestClient client) {
        String path = "/v3/ips";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<ListIp200ResponseInner>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.ip != null) {
            request.addQueryParam("ip", this.ip.toString());
        }
        if (this.excludeWhitelabels != null) {
            request.addQueryParam("exclude_whitelabels", this.excludeWhitelabels.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
        if (this.offset != null) {
            request.addQueryParam("offset", this.offset.toString());
        }
        if (this.subuser != null) {
            request.addQueryParam("subuser", this.subuser.toString());
        }
        if (this.sortByDirection != null) {
            request.addQueryParam("sort_by_direction", this.sortByDirection.toString());
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setExcludeWhitelabels(Boolean excludeWhitelabels) {
        this.excludeWhitelabels = excludeWhitelabels;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSubuser(String subuser) {
        this.subuser = subuser;
    }

    public void setSortByDirection(SortByDirection sortByDirection) {
        this.sortByDirection = sortByDirection;
    }
}

