/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ips;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ips.models.CreateIpPoolRequest;
import com.sendgrid.rest.api.v3.ips.models.IpPools200;
import com.sendgrid.util.JsonUtil;

public class CreateIpPool
extends ApiKeyBase {
    private CreateIpPoolRequest createIpPoolRequest;

    @Override
    public ApiResponse<IpPools200> send(ApiKeyRestClient client) {
        String path = "/v3/ips/pools";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CreateIpPool creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<IpPools200>(statusCode, JsonUtil.fromJson(response.getStream(), IpPools200.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.createIpPoolRequest != null) {
            request.addBody(JsonUtil.toJson(this.createIpPoolRequest));
        }
    }

    public void setCreateIpPoolRequest(CreateIpPoolRequest createIpPoolRequest) {
        this.createIpPoolRequest = createIpPoolRequest;
    }
}

