/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipaddressmanagement;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.IpAddressManagementErrorResponse;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.ListSubUserAssignedToIp200Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ListSubUserAssignedToIp
extends ApiKeyBase {
    private Integer afterKey;
    private Integer limit;

    @Override
    public ApiResponse<ListSubUserAssignedToIp200Response> send(ApiKeyRestClient client) {
        String path = "/v3/send_ips/ips/{ip}/subusers";
        Request request = new Request(HttpMethod.GET, path, Domains.API.toString());
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ListSubUserAssignedToIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ListSubUserAssignedToIp200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ListSubUserAssignedToIp200Response.class), response.getHeaders());
    }

    private void addQueryParams(Request request) {
        if (this.afterKey != null) {
            request.addQueryParam("after_key", this.afterKey.toString());
        }
        if (this.limit != null) {
            request.addQueryParam("limit", this.limit.toString());
        }
    }

    public void setAfterKey(Integer afterKey) {
        this.afterKey = afterKey;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

