/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.ipaddressmanagement;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.AddIp201Response;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.AddIpRequest;
import com.sendgrid.rest.api.v3.ipaddressmanagement.models.IpAddressManagementErrorResponse;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class AddIp
extends ApiKeyBase {
    private AddIpRequest addIpRequest;

    @Override
    public ApiResponse<AddIp201Response> send(ApiKeyRestClient client) {
        String path = "/v3/send_ips/ips";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddIp creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                IpAddressManagementErrorResponse error = JsonUtil.fromJson(response.getStream(), IpAddressManagementErrorResponse.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<AddIp201Response>(statusCode, JsonUtil.fromJson(response.getStream(), AddIp201Response.class), response.getHeaders());
    }

    private void addBody(Request request) {
        if (this.addIpRequest != null) {
            request.addBody(JsonUtil.toJson(this.addIpRequest));
        }
    }

    public void setAddIpRequest(AddIpRequest addIpRequest) {
        this.addIpRequest = addIpRequest;
    }
}

