/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.ValidateAuthenticatedDomain200Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.ValidateAuthenticatedDomain500Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class ValidateAuthenticatedDomain
extends ApiKeyBase {
    private final Integer id;
    private String onBehalfOf;

    @Override
    public ApiResponse<ValidateAuthenticatedDomain200Response> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains/{id}/validate";
        Request request = new Request(HttpMethod.POST, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ValidateAuthenticatedDomain creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "500")) {
                ValidateAuthenticatedDomain500Response error = JsonUtil.fromJson(response.getStream(), ValidateAuthenticatedDomain500Response.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<ValidateAuthenticatedDomain200Response>(statusCode, JsonUtil.fromJson(response.getStream(), ValidateAuthenticatedDomain200Response.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.id != null) {
            request.addPathParam("id", this.id.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    public ValidateAuthenticatedDomain(Integer id) {
        this.id = id;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }
}

