/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.rest.api.v3.domainauthentication.models.UpdateAuthenticatedDomainRequest;
import com.sendgrid.util.JsonUtil;
import java.util.List;

public class UpdateAuthenticatedDomain
extends ApiKeyBase {
    private final String domainId;
    private String onBehalfOf;
    private UpdateAuthenticatedDomainRequest updateAuthenticatedDomainRequest;

    @Override
    public ApiResponse<List<Object>> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains/{domain_id}";
        Request request = new Request(HttpMethod.PATCH, path, Domains.API.toString());
        this.addPathParams(request);
        this.addHeaderParams(request);
        this.addBody(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UpdateAuthenticatedDomain creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<List<Object>>(statusCode, JsonUtil.fromJson(response.getStream(), List.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.domainId != null) {
            request.addPathParam("domain_id", this.domainId.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.onBehalfOf != null) {
            request.addHeaderParam("on-behalf-of", this.onBehalfOf.toString());
        }
    }

    private void addBody(Request request) {
        if (this.updateAuthenticatedDomainRequest != null) {
            request.addBody(JsonUtil.toJson(this.updateAuthenticatedDomainRequest));
        }
    }

    public UpdateAuthenticatedDomain(String domainId) {
        this.domainId = domainId;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setUpdateAuthenticatedDomainRequest(UpdateAuthenticatedDomainRequest updateAuthenticatedDomainRequest) {
        this.updateAuthenticatedDomainRequest = updateAuthenticatedDomainRequest;
    }
}

