/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.domainauthentication;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.util.JsonUtil;

public class DisassociateSubuserFromDomain
extends ApiKeyBase {
    private final Integer domainId;
    private String username;

    @Override
    public ApiResponse<Object> send(ApiKeyRestClient client) {
        String path = "/v3/whitelabel/domains/{domain_id}/subuser";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DisassociateSubuserFromDomain creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Object>(statusCode, JsonUtil.fromJson(response.getStream(), Object.class), response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.domainId != null) {
            request.addPathParam("domain_id", this.domainId.toString());
        }
    }

    private void addQueryParams(Request request) {
        if (this.username != null) {
            request.addQueryParam("username", this.username.toString());
        }
    }

    public DisassociateSubuserFromDomain(Integer domainId) {
        this.domainId = domainId;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

