/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.rest.api.v3.accountprovisioning;

import com.sendgrid.base.apikey.ApiKeyBase;
import com.sendgrid.constant.ApplicationConstants;
import com.sendgrid.constant.Domains;
import com.sendgrid.exception.ApiConnectionException;
import com.sendgrid.exception.ApiErrorResponse;
import com.sendgrid.exception.GenericApiError;
import com.sendgrid.http.ApiKeyRestClient;
import com.sendgrid.http.ApiResponse;
import com.sendgrid.http.HttpMethod;
import com.sendgrid.http.Request;
import com.sendgrid.http.Response;
import com.sendgrid.util.JsonUtil;
import com.sendgrid.util.Matcher;

public class DeleteAccount
extends ApiKeyBase {
    private final String accountID;

    @Override
    public ApiResponse<Void> send(ApiKeyRestClient client) {
        String path = "/v3/partners/accounts/{accountID}";
        Request request = new Request(HttpMethod.DELETE, path, Domains.API.toString());
        this.addPathParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeleteAccount creation failed: Unable to connect to server");
        }
        if (!ApplicationConstants.SUCCESS.test(response.getStatusCode())) {
            int statusCode = response.getStatusCode();
            if (Matcher.matches(Integer.toString(statusCode), "400")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "401")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "403")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            if (Matcher.matches(Integer.toString(statusCode), "404")) {
                Object error = JsonUtil.fromJson(response.getStream(), Object.class);
                throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
            }
            GenericApiError error = JsonUtil.fromJson(response.getStream(), GenericApiError.class);
            throw new ApiErrorResponse(statusCode, null, error, response.getHeaders());
        }
        int statusCode = response.getStatusCode();
        return new ApiResponse<Void>(statusCode, response.getHeaders());
    }

    private void addPathParams(Request request) {
        if (this.accountID != null) {
            request.addPathParam("accountID", this.accountID.toString());
        }
    }

    public DeleteAccount(String accountID) {
        this.accountID = accountID;
    }
}

