/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.http.httpclient;

import com.sendgrid.constant.Config;
import java.util.List;

final class HttpUtility {
    public static String getUserAgentString(List<String> userAgentExtensions) {
        StringBuilder userAgentString = new StringBuilder();
        userAgentString.append("sendgrid-java/").append("5.0.0-rc.1").append(" (").append(Config.OS_NAME).append(" ").append(Config.OS_ARCH).append(") ").append("java/").append(Config.JAVA_VERSION);
        if (userAgentExtensions != null && !userAgentExtensions.isEmpty()) {
            userAgentExtensions.stream().forEach(userAgentExtension -> {
                userAgentString.append(" ");
                userAgentString.append((String)userAgentExtension);
            });
        }
        return userAgentString.toString();
    }

    public static String getUserAgentString(List<String> userAgentExtensions, boolean isCustomClient) {
        return isCustomClient ? HttpUtility.getUserAgentString(userAgentExtensions) + " custom" : HttpUtility.getUserAgentString(userAgentExtensions);
    }

    private HttpUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

